/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.app.Instrumentation;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.test.core.app.ApplicationProvider;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$0;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$1;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$2;
import androidx.test.core.app.InstrumentationActivityInvoker$$Lambda$3;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.platform.app.ActivityInvoker$;
import androidx.test.internal.platform.app.ActivityLifecycleTimeout;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class InstrumentationActivityInvoker
implements ActivityInvoker {
    private static final String TARGET_ACTIVITY_INTENT_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.START_TARGET_ACTIVITY_INTENT_KEY";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_RECEIVED = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY";
    private static final String BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY = "androidx.test.core.app.InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY";
    private static final String EMPTY_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED";
    private static final String EMPTY_FLOATING_ACTIVITY_RESUMED = "androidx.test.core.app.InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED";
    private static final String FINISH_BOOTSTRAP_ACTIVITY = "androidx.test.core.app.InstrumentationActivityInvoker.FINISH_BOOTSTRAP_ACTIVITY";
    private static final String FINISH_EMPTY_ACTIVITIES = "androidx.test.core.app.InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES";
    @Nullable
    private ActivityResultWaiter activityResultWaiter;

    InstrumentationActivityInvoker() {
    }

    public void startActivity(Intent intent) {
        ActivityInfo ai = intent.resolveActivityInfo(ApplicationProvider.getApplicationContext().getPackageManager(), 0);
        if (ai == null) {
            String string = String.valueOf(intent);
            throw new RuntimeException(new StringBuilder(32 + String.valueOf(string).length()).append("Unable to resolve activity for: ").append(string).toString());
        }
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_BOOTSTRAP_ACTIVITY));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
        this.activityResultWaiter = new ActivityResultWaiter((Context)ApplicationProvider.getApplicationContext());
        ApplicationProvider.getApplicationContext().startActivity(this.getIntentForActivity(BootstrapActivity.class).setFlags(0x10008000).putExtra(TARGET_ACTIVITY_INTENT_KEY, (Parcelable)PendingIntent.getActivity(ApplicationProvider.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000)));
    }

    public Instrumentation.ActivityResult getActivityResult() {
        return ((ActivityResultWaiter)Checks.checkNotNull((Object)this.activityResultWaiter, (Object)"You must start Activity first")).getActivityResult();
    }

    public void resumeActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
    }

    public void pauseActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED);
        this.startFloatingEmptyActivitySync();
    }

    private void startFloatingEmptyActivitySync() {
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        ApplicationProvider.getApplicationContext().registerReceiver(receiver, new IntentFilter(EMPTY_FLOATING_ACTIVITY_RESUMED));
        ApplicationProvider.getApplicationContext().startActivity(this.getIntentForActivity(EmptyFloatingActivity.class).setFlags(0x10000000));
        try {
            latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Failed to pause activity", e);
        }
        finally {
            ApplicationProvider.getApplicationContext().unregisterReceiver(receiver);
        }
    }

    public void stopActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        this.startEmptyActivitySync();
    }

    private void startEmptyActivitySync() {
        final CountDownLatch latch = new CountDownLatch(1);
        BroadcastReceiver receiver = new BroadcastReceiver(this){

            public void onReceive(Context context, Intent intent) {
                latch.countDown();
            }
        };
        ApplicationProvider.getApplicationContext().registerReceiver(receiver, new IntentFilter(EMPTY_ACTIVITY_RESUMED));
        ApplicationProvider.getApplicationContext().startActivity(this.getIntentForActivity(EmptyActivity.class).setFlags(0x10000000));
        try {
            latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Failed to stop activity", e);
        }
        finally {
            ApplicationProvider.getApplicationContext().unregisterReceiver(receiver);
        }
    }

    public void recreateActivity(Activity activity) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, Stage.RESUMED, Stage.PAUSED, Stage.STOPPED);
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$0(activity));
    }

    public void finishActivity(Activity activity) {
        this.startEmptyActivitySync();
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$1(activity));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_BOOTSTRAP_ACTIVITY));
        this.startEmptyActivitySync();
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$2(activity));
        ApplicationProvider.getApplicationContext().sendBroadcast(new Intent(FINISH_EMPTY_ACTIVITIES));
    }

    private static void checkActivityStageIsIn(Activity activity, Stage ... expected) {
        InstrumentationActivityInvoker.checkActivityStageIsIn(activity, new HashSet<Stage>(Arrays.asList(expected)));
    }

    private static void checkActivityStageIsIn(Activity activity, Set<Stage> expected) {
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new InstrumentationActivityInvoker$$Lambda$3(activity, expected));
    }

    static final /* synthetic */ void lambda$checkActivityStageIsIn$3$InstrumentationActivityInvoker(Activity activity, Set expected) {
        Stage stage = ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity);
        Checks.checkState((boolean)expected.contains(stage), (String)"Activity's stage must be %s but was %s", (Object[])new Object[]{expected, stage});
    }

    static final /* synthetic */ void lambda$finishActivity$2$InstrumentationActivityInvoker(Activity activity) {
        activity.finish();
    }

    static final /* synthetic */ void lambda$finishActivity$1$InstrumentationActivityInvoker(Activity activity) {
        activity.finish();
    }

    static final /* synthetic */ void lambda$recreateActivity$0$InstrumentationActivityInvoker(Activity activity) {
        activity.recreate();
    }

    public Intent getIntentForActivity(Class clazz) {
        return ActivityInvoker$.CC.getIntentForActivity$$dflt$$((ActivityInvoker)this, (Class)clazz);
    }

    public static class EmptyFloatingActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyFloatingActivity.this.finish();
            }
        };

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_FLOATING_ACTIVITY_RESUMED));
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }
    }

    public static class EmptyActivity
    extends Activity {
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                EmptyActivity.this.finish();
            }
        };

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_EMPTY_ACTIVITIES));
        }

        protected void onResume() {
            super.onResume();
            this.sendBroadcast(new Intent(InstrumentationActivityInvoker.EMPTY_ACTIVITY_RESUMED));
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }
    }

    private static class ActivityResultWaiter {
        private static final String TAG = ActivityResultWaiter.class.getName();
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private Instrumentation.ActivityResult activityResult;

        public ActivityResultWaiter(Context context) {
            BroadcastReceiver receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    context.unregisterReceiver((BroadcastReceiver)this);
                    int resultCode = intent.getIntExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY, 0);
                    Intent resultData = (Intent)intent.getParcelableExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY);
                    if (resultData != null) {
                        resultData = new Intent(resultData);
                    }
                    ActivityResultWaiter.this.activityResult = new Instrumentation.ActivityResult(resultCode, resultData);
                    ActivityResultWaiter.this.latch.countDown();
                }
            };
            context.registerReceiver(receiver, new IntentFilter(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED));
        }

        public Instrumentation.ActivityResult getActivityResult() {
            try {
                this.latch.await(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Log.i((String)TAG, (String)"Waiting activity result was interrupted", (Throwable)e);
            }
            Checks.checkNotNull((Object)this.activityResult, (String)"onActivityResult never be called after %d milliseconds", (Object[])new Object[]{ActivityLifecycleTimeout.getMillis()});
            return this.activityResult;
        }
    }

    public static class BootstrapActivity
    extends Activity {
        private static final String TAG = BootstrapActivity.class.getName();
        private static final String IS_TARGET_ACTIVITY_STARTED_KEY = "IS_TARGET_ACTIVITY_STARTED_KEY";
        private final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BootstrapActivity.this.finishActivity(0);
                BootstrapActivity.this.finish();
            }
        };
        private boolean isTargetActivityStarted;

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.registerReceiver(this.receiver, new IntentFilter(InstrumentationActivityInvoker.FINISH_BOOTSTRAP_ACTIVITY));
            this.isTargetActivityStarted = savedInstanceState != null && savedInstanceState.getBoolean(IS_TARGET_ACTIVITY_STARTED_KEY, false);
        }

        protected void onResume() {
            super.onResume();
            if (!this.isTargetActivityStarted) {
                this.isTargetActivityStarted = true;
                PendingIntent startTargetActivityIntent = (PendingIntent)Checks.checkNotNull((Object)((PendingIntent)this.getIntent().getParcelableExtra(InstrumentationActivityInvoker.TARGET_ACTIVITY_INTENT_KEY)));
                try {
                    this.startIntentSenderForResult(startTargetActivityIntent.getIntentSender(), 0, null, 0x10000000, 0, 0);
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e((String)TAG, (String)"Failed to start target activity.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        protected void onSaveInstanceState(Bundle outState) {
            super.onSaveInstanceState(outState);
            outState.putBoolean(IS_TARGET_ACTIVITY_STARTED_KEY, this.isTargetActivityStarted);
        }

        protected void onDestroy() {
            super.onDestroy();
            this.unregisterReceiver(this.receiver);
        }

        protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            if (requestCode == 0) {
                Intent activityResultReceivedActionIntent = new Intent(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_RECEIVED);
                activityResultReceivedActionIntent.putExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_CODE_KEY, resultCode);
                if (data != null) {
                    activityResultReceivedActionIntent.putExtra(InstrumentationActivityInvoker.BOOTSTRAP_ACTIVITY_RESULT_DATA_KEY, (Parcelable)data);
                }
                this.sendBroadcast(activityResultReceivedActionIntent);
                this.finish();
            }
        }
    }
}

