/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.junit.rules;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.test.core.app.ApplicationProvider;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class DeleteFilesRule
implements TestRule {
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Context context = ApplicationProvider.getApplicationContext();
                ArrayList<File> directories = new ArrayList<File>();
                directories.add(new File(context.getApplicationInfo().dataDir));
                directories.add(Environment.getExternalStorageDirectory());
                directories.add(Environment.getDownloadCacheDirectory());
                if (context.getExternalCacheDir() != null) {
                    directories.add(context.getExternalCacheDir());
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    directories.add(context.getNoBackupFilesDir());
                }
                if (Build.VERSION.SDK_INT >= 24) {
                    directories.add(new File(context.getApplicationInfo().deviceProtectedDataDir));
                }
                HashSet existingFiles = new HashSet();
                for (File directory : directories) {
                    DeleteFilesRule.findFilesRecursively(existingFiles, directory);
                }
                try {
                    base.evaluate();
                }
                finally {
                    for (File directory : directories) {
                        DeleteFilesRule.deleteFilesRecursively(existingFiles, directory);
                    }
                }
            }
        };
    }

    private static boolean isConstant(File file) {
        return file.getName().endsWith(".dex");
    }

    private static void findFilesRecursively(Set<File> existingFiles, File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                existingFiles.add(file);
                if (!file.isDirectory()) continue;
                DeleteFilesRule.findFilesRecursively(existingFiles, file);
            }
        }
    }

    private static void deleteFilesRecursively(Set<File> existingFiles, File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (PlatformTestStorageRegistry.getInstance().isTestStorageFilePath(file.getPath())) continue;
                    DeleteFilesRule.deleteFilesRecursively(existingFiles, file);
                    if (existingFiles.contains(file) || !file.exists()) continue;
                    File[] filesInDirectory = file.listFiles();
                    if (filesInDirectory == null && !file.delete()) {
                        System.err.println("DeleteRules failed to delete (not a directory or I/O error): " + file);
                        continue;
                    }
                    if (filesInDirectory.length != 0 || file.delete()) continue;
                    System.err.println("DeleteRules failed to delete: " + file);
                    continue;
                }
                if (existingFiles.contains(file) || !file.exists() || DeleteFilesRule.isConstant(file) || file.delete()) continue;
                System.err.println("DeleteRules failed to delete: " + file);
            }
        }
    }
}

