/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.content;

import android.content.Intent;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.truth.Correspondence;

public final class IntentCorrespondences {
    private IntentCorrespondences() {
    }

    public static Correspondence<Intent, Intent> action() {
        return new Correspondence<Intent, Intent>(){

            public boolean compare(Intent actual, Intent expected) {
                return Objects.equal((Object)actual.getAction(), (Object)expected.getAction());
            }

            public String toString() {
                return "has getAction() equal to";
            }
        };
    }

    public static Correspondence<Intent, Intent> data() {
        return new Correspondence<Intent, Intent>(){

            public boolean compare(Intent actual, Intent expected) {
                return Objects.equal((Object)actual.getData(), (Object)expected.getData());
            }

            public String toString() {
                return "has getData() equal to";
            }
        };
    }

    @Beta
    public static Correspondence<Intent, Intent> all(final Correspondence<Intent, Intent> ... correspondences) {
        return new Correspondence<Intent, Intent>(){

            public boolean compare(Intent actual, Intent expected) {
                for (Correspondence innerCorrespondence : correspondences) {
                    if (innerCorrespondence.compare((Object)actual, (Object)expected)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder combinedString = new StringBuilder();
                for (int i = 0; i < correspondences.length; ++i) {
                    combinedString.append(correspondences[i]);
                    if (i + 1 >= correspondences.length) continue;
                    combinedString.append(" and ");
                }
                return combinedString.toString();
            }
        };
    }
}

