/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.ext.truth.os;

import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;

@RequiresApi(value=21)
public final class PersistableBundleSubject
extends Subject {
    private final PersistableBundle actual;

    public static PersistableBundleSubject assertThat(PersistableBundle persistableBundle) {
        return (PersistableBundleSubject)Truth.assertAbout(PersistableBundleSubject.persistableBundles()).that((Object)persistableBundle);
    }

    public static Subject.Factory<PersistableBundleSubject, PersistableBundle> persistableBundles() {
        return PersistableBundleSubject::new;
    }

    PersistableBundleSubject(FailureMetadata failureMetadata, PersistableBundle subject) {
        super(failureMetadata, (Object)subject);
        this.actual = subject;
    }

    public void hasSize(int size) {
        this.check("size()", new Object[0]).that(Integer.valueOf(this.actual.size())).isEqualTo((Object)size);
    }

    public void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be non-empty"), new Fact[0]);
        }
    }

    public StringSubject string(String key) {
        return this.check("getString(%s)", new Object[]{key}).that(this.actual.getString(key));
    }

    public IntegerSubject integer(String key) {
        return this.check("getInt(%s)", new Object[]{key}).that(Integer.valueOf(this.actual.getInt(key)));
    }

    public LongSubject longInt(String key) {
        return this.check("getLong(%s)", new Object[]{key}).that(Long.valueOf(this.actual.getLong(key)));
    }

    @NonNull
    public DoubleSubject doubleFloat(@NonNull String key) {
        return this.check("getDouble(%s)", new Object[]{key}).that(Double.valueOf(this.actual.getDouble(key)));
    }

    @RequiresApi(value=22)
    public BooleanSubject bool(String key) {
        return this.check("getBoolean(%s)", new Object[]{key}).that(Boolean.valueOf(this.actual.getBoolean(key)));
    }

    @NonNull
    public ObjectArraySubject<String> stringArray(@NonNull String key) {
        return this.check("getStringArray(%s)", new Object[]{key}).that((Object[])this.actual.getStringArray(key));
    }

    public PersistableBundleSubject persistableBundle(String key) {
        return (PersistableBundleSubject)this.check("getPersistableBundle(%s)", new Object[]{key}).about(PersistableBundleSubject.persistableBundles()).that((Object)this.actual.getPersistableBundle(key));
    }

    public void containsKey(String key) {
        if (!this.actual.containsKey(key)) {
            this.failWithActual(Fact.simpleFact((String)("expected to contain key " + key)), new Fact[0]);
        }
    }

    public void doesNotContainKey(String key) {
        if (this.actual.containsKey(key)) {
            this.failWithActual(Fact.simpleFact((String)("expected to not contain key " + key)), new Fact[0]);
        }
    }
}

