/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform.reflect;

import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.reflect.ReflectionException;
import java.lang.reflect.Field;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReflectiveField<T> {
    private final String className;
    private final String fieldName;
    private final Class<?> clazz;
    private boolean initialized = false;
    private Field field;

    public ReflectiveField(String className, String fieldName) {
        this.clazz = null;
        this.className = className;
        this.fieldName = fieldName;
    }

    public ReflectiveField(Class<?> clazz, String fieldName) {
        this.clazz = clazz;
        this.className = null;
        this.fieldName = fieldName;
    }

    public T get(Object object) throws ReflectionException {
        try {
            this.initIfNecessary();
            return (T)this.field.get(object);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    private synchronized void initIfNecessary() throws ClassNotFoundException, NoSuchFieldException {
        if (this.initialized) {
            return;
        }
        this.field = this.getClazz().getDeclaredField(this.fieldName);
        this.field.setAccessible(true);
        this.initialized = true;
    }

    private Class<?> getClazz() throws ClassNotFoundException {
        if (this.clazz == null) {
            return Class.forName(this.className);
        }
        return this.clazz;
    }
}

