/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.tracing;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.platform.tracing.Tracer;
import androidx.tracing.Trace;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;

class AndroidXTracer
implements Tracer {
    private static final String TAG = AndroidXTracer.class.getSimpleName();
    private static final int MAX_SECTION_NAME_LEN = 127;

    AndroidXTracer() {
    }

    @CanIgnoreReturnValue
    public AndroidXTracer enableTracing() {
        try {
            Trace.forceEnableAppTracing();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"enableTracing failed", (Throwable)e);
        }
        return this;
    }

    @Override
    @NonNull
    public Tracer.Span beginSpan(@NonNull String name) {
        Trace.beginSection((String)AndroidXTracer.sanitizeSpanName(name));
        return new AndroidXTracerSpan();
    }

    @NonNull
    private static String sanitizeSpanName(@NonNull String name) {
        if (name.length() > 127) {
            Log.w((String)TAG, (String)("Span name exceeds limits: " + name));
            name = name.substring(0, 127);
        }
        return name;
    }

    private static class AndroidXTracerSpan
    implements Tracer.Span {
        private final ArrayDeque<AndroidXTracerSpan> nestedSpans = new ArrayDeque();

        private AndroidXTracerSpan() {
        }

        @Override
        @NonNull
        public Tracer.Span beginChildSpan(@NonNull String name) {
            Trace.beginSection((String)AndroidXTracer.sanitizeSpanName(name));
            AndroidXTracerSpan span = new AndroidXTracerSpan();
            this.nestedSpans.add(span);
            return span;
        }

        @Override
        public void close() {
            AndroidXTracerSpan span;
            while ((span = this.nestedSpans.pollLast()) != null) {
                span.close();
            }
            Trace.endSection();
        }
    }
}

