/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.Beta;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.content.PermissionGranter;
import androidx.test.internal.util.Checks;
import androidx.test.rule.GrantPermissionRule$$Lambda$0;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public class GrantPermissionRule
implements TestRule {
    private PermissionGranter permissionGranter;

    private GrantPermissionRule() {
        this((PermissionGranter)ServiceLoaderWrapper.loadSingleService(PermissionGranter.class, (ServiceLoaderWrapper.Factory)GrantPermissionRule$$Lambda$0.$instance));
    }

    @VisibleForTesting
    GrantPermissionRule(@NonNull PermissionGranter permissionGranter) {
        this.setPermissionGranter(permissionGranter);
    }

    public static GrantPermissionRule grant(String ... permissions) {
        GrantPermissionRule grantPermissionRule = new GrantPermissionRule();
        grantPermissionRule.grantPermissions(permissions);
        return grantPermissionRule;
    }

    private void grantPermissions(String ... permissions) {
        Set<String> permissionSet = this.satisfyPermissionDependencies(permissions);
        this.permissionGranter.addPermissions(permissionSet.toArray(new String[permissionSet.size()]));
    }

    @VisibleForTesting
    Set<String> satisfyPermissionDependencies(String ... permissions) {
        LinkedHashSet<String> permissionList = new LinkedHashSet<String>(Arrays.asList(permissions));
        if (permissionList.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
            permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        return permissionList;
    }

    public final Statement apply(Statement base, Description description) {
        return new RequestPermissionStatement(base);
    }

    @VisibleForTesting
    void setPermissionGranter(PermissionGranter permissionGranter) {
        this.permissionGranter = (PermissionGranter)Checks.checkNotNull((Object)permissionGranter, (Object)"permissionRequester cannot be null!");
    }

    private class RequestPermissionStatement
    extends Statement {
        private final Statement base;

        public RequestPermissionStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            GrantPermissionRule.this.permissionGranter.requestPermissions();
            this.base.evaluate();
        }
    }
}

