/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.content.PermissionGranter;
import androidx.test.internal.util.Checks;
import androidx.test.rule.GrantPermissionRule$$ExternalSyntheticLambda0;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GrantPermissionRule
implements TestRule {
    private PermissionGranter permissionGranter;

    public static GrantPermissionRule grant(String ... permissions) {
        GrantPermissionRule grantPermissionRule = new GrantPermissionRule();
        grantPermissionRule.grantPermissions(permissions);
        return grantPermissionRule;
    }

    @VisibleForTesting
    Set<String> satisfyPermissionDependencies(String ... permissions) {
        LinkedHashSet<String> permissionList = new LinkedHashSet<String>(Arrays.asList(permissions));
        if (permissionList.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
            permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        return permissionList;
    }

    public final Statement apply(Statement base, Description description) {
        return new RequestPermissionStatement(base);
    }

    private GrantPermissionRule() {
        this((PermissionGranter)ServiceLoaderWrapper.loadSingleService(PermissionGranter.class, (ServiceLoaderWrapper.Factory)GrantPermissionRule$$ExternalSyntheticLambda0.INSTANCE));
    }

    @VisibleForTesting
    GrantPermissionRule(@NonNull PermissionGranter permissionGranter) {
        this.setPermissionGranter(permissionGranter);
    }

    private void grantPermissions(String ... permissions) {
        Set<String> permissionSet = this.satisfyPermissionDependencies(permissions);
        this.permissionGranter.addPermissions(permissionSet.toArray(new String[permissionSet.size()]));
    }

    @VisibleForTesting
    void setPermissionGranter(PermissionGranter permissionGranter) {
        this.permissionGranter = (PermissionGranter)Checks.checkNotNull((Object)permissionGranter, (Object)"permissionRequester cannot be null!");
    }

    private class RequestPermissionStatement
    extends Statement {
        private final Statement base;

        public RequestPermissionStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            GrantPermissionRule.this.permissionGranter.requestPermissions();
            this.base.evaluate();
        }
    }
}

