/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.rule.provider;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.util.Checks;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

class DelegatingContext
extends ContextWrapper {
    private static final String TAG = "DelegatingContext";
    private static final int NO_OP_UID = -1;
    private static final int NO_OP_PID = -1;
    private final String prefix;
    private final Context context;
    private final ContentResolver contentResolver;
    private Set<String> databases = new HashSet<String>();
    private Set<String> files = new HashSet<String>();
    private Set<String> revokedPermissions = new HashSet<String>();

    public DelegatingContext(@NonNull Context context, @NonNull String prefix, @NonNull ContentResolver contentResolver) {
        super((Context)Checks.checkNotNull((Object)context));
        this.context = context;
        this.prefix = (String)Checks.checkNotNull((Object)prefix);
        this.contentResolver = (ContentResolver)Checks.checkNotNull((Object)contentResolver);
    }

    public ContentResolver getContentResolver() {
        return this.contentResolver;
    }

    public File getDir(@NonNull String name, int mode) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Directory name cannot be empty or null");
        return this.context.getDir(this.getPrefixName(name), mode);
    }

    public SQLiteDatabase openOrCreateDatabase(@NonNull String name, int mode, SQLiteDatabase.CursorFactory factory) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Database name cannot be empty or null");
        if (!this.databases.contains(name)) {
            this.addDatabase(name);
            String prefixName = this.getPrefixName(name);
            if (this.context.getDatabasePath(prefixName).exists() && !this.context.deleteDatabase(prefixName)) {
                Log.w((String)TAG, (String)("Database with prefixed name " + prefixName + " already exists but failed to delete."));
            }
        }
        return this.context.openOrCreateDatabase(this.getPrefixName(name), mode, factory);
    }

    public SQLiteDatabase openOrCreateDatabase(@NonNull String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Database name cannot be empty or null");
        String prefixName = this.getPrefixName(name);
        if (!this.databases.contains(name)) {
            this.addDatabase(name);
            if (this.context.getDatabasePath(prefixName).exists() && !this.context.deleteDatabase(prefixName)) {
                Log.w((String)TAG, (String)("Database with prefixed name " + prefixName + " already exists and cannot be deleted."));
            }
        }
        return this.context.openOrCreateDatabase(prefixName, mode, factory, errorHandler);
    }

    public String[] databaseList() {
        return this.databases.toArray(new String[this.databases.size()]);
    }

    public boolean deleteDatabase(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Database name cannot be empty or null");
        if (this.databases.contains(name) && this.context.deleteDatabase(this.getPrefixName(name))) {
            this.databases.remove(name);
            return true;
        }
        return false;
    }

    public File getDatabasePath(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Database name cannot be empty or null");
        return this.context.getDatabasePath(this.getPrefixName(name));
    }

    public FileInputStream openFileInput(@NonNull String name) throws FileNotFoundException {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"File name cannot be empty or null");
        if (!this.files.contains(name)) {
            throw new FileNotFoundException(String.format("File %s is not found in current context", name));
        }
        return this.context.openFileInput(this.getPrefixName(name));
    }

    public FileOutputStream openFileOutput(@NonNull String name, int mode) throws FileNotFoundException {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"File name cannot be empty or null");
        FileOutputStream fos = this.context.openFileOutput(this.getPrefixName(name), mode);
        if (fos != null) {
            this.files.add(name);
        }
        return fos;
    }

    public String[] fileList() {
        return this.files.toArray(new String[this.files.size()]);
    }

    public File getFileStreamPath(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"File name cannot be empty or null");
        return this.context.getFileStreamPath(this.getPrefixName(name));
    }

    public boolean deleteFile(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"File name cannot be empty or null");
        if (this.files.contains(name) && this.context.deleteFile(this.getPrefixName(name))) {
            this.files.remove(name);
            return true;
        }
        return false;
    }

    public Object getSystemService(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"name cannot be empty or null");
        if ("appops".equals(name)) {
            return this.context.getSystemService("appops");
        }
        throw new UnsupportedOperationException();
    }

    public int checkPermission(@NonNull String permission2, int pid, int uid) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)permission2) ? 1 : 0) != 0, (Object)"permission cannot be null or empty");
        if (this.revokedPermissions.contains(permission2)) {
            return -1;
        }
        return 0;
    }

    public int checkCallingPermission(@NonNull String permission2) {
        return this.checkPermission(permission2, -1, -1);
    }

    public int checkCallingOrSelfPermission(@NonNull String permission2) {
        return this.checkPermission(permission2, -1, -1);
    }

    public int checkSelfPermission(@NonNull String permission2) {
        return this.checkPermission(permission2, -1, -1);
    }

    public void enforcePermission(@NonNull String permission2, int pid, int uid, String message) {
        if (this.checkPermission(permission2, pid, uid) != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + "No permission " + permission2);
        }
    }

    public void enforceCallingPermission(@NonNull String permission2, String message) {
        this.enforcePermission(permission2, -1, -1, message);
    }

    public void enforceCallingOrSelfPermission(@NonNull String permission2, String message) {
        this.enforcePermission(permission2, -1, -1, message);
    }

    public int checkUriPermission(@NonNull Uri uri, int pid, int uid, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public int checkCallingUriPermission(@NonNull Uri uri, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public int checkCallingOrSelfUriPermission(@NonNull Uri uri, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public int checkUriPermission(@Nullable Uri uri, @Nullable String readPermission, @Nullable String writePermission, int pid, int uid, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public void enforceUriPermission(@NonNull Uri uri, int pid, int uid, int modeFlags, String message) {
        throw new UnsupportedOperationException();
    }

    public void enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
        throw new UnsupportedOperationException();
    }

    public void enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
        throw new UnsupportedOperationException();
    }

    public void enforceUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags, String message) {
        throw new UnsupportedOperationException();
    }

    public Context getApplicationContext() {
        return this;
    }

    public File getFilesDir() {
        throw new UnsupportedOperationException();
    }

    public File getNoBackupFilesDir() {
        throw new UnsupportedOperationException();
    }

    public File getExternalFilesDir(String s) {
        throw new UnsupportedOperationException();
    }

    public File getObbDir() {
        throw new UnsupportedOperationException();
    }

    public File[] getObbDirs() {
        throw new UnsupportedOperationException();
    }

    public File getCacheDir() {
        throw new UnsupportedOperationException();
    }

    public File getCodeCacheDir() {
        throw new UnsupportedOperationException();
    }

    public File getExternalCacheDir() {
        throw new UnsupportedOperationException();
    }

    public File[] getExternalCacheDirs() {
        throw new UnsupportedOperationException();
    }

    public File[] getExternalMediaDirs() {
        throw new UnsupportedOperationException();
    }

    public File[] getExternalFilesDirs(String s) {
        throw new UnsupportedOperationException();
    }

    public PackageManager getPackageManager() {
        throw new UnsupportedOperationException();
    }

    public Looper getMainLooper() {
        throw new UnsupportedOperationException();
    }

    public void setTheme(int resID) {
        throw new UnsupportedOperationException();
    }

    public Resources.Theme getTheme() {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException();
    }

    public String getPackageName() {
        throw new UnsupportedOperationException();
    }

    public ApplicationInfo getApplicationInfo() {
        throw new UnsupportedOperationException();
    }

    public String getPackageResourcePath() {
        throw new UnsupportedOperationException();
    }

    public String getPackageCodePath() {
        throw new UnsupportedOperationException();
    }

    public void sendBroadcast(Intent intent, String s) {
        throw new UnsupportedOperationException();
    }

    public void sendBroadcast(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public void sendOrderedBroadcast(@NonNull Intent intent, String s, BroadcastReceiver broadcastReceiver, Handler handler, int i, String s1, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void sendOrderedBroadcast(Intent intent, String s) {
        throw new UnsupportedOperationException();
    }

    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String s, BroadcastReceiver broadcastReceiver, Handler handler, int i, String s1, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle) {
        throw new UnsupportedOperationException();
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle, String s) {
        throw new UnsupportedOperationException();
    }

    public void sendStickyBroadcast(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public void sendStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        throw new UnsupportedOperationException();
    }

    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int i, String s, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, BroadcastReceiver broadcastReceiver, Handler handler, int i, String s, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void removeStickyBroadcast(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public void removeStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        throw new UnsupportedOperationException();
    }

    public void grantUriPermission(String toPackage, Uri uri, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public void revokeUriPermission(Uri uri, int modeFlags) {
        throw new UnsupportedOperationException();
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        throw new UnsupportedOperationException();
    }

    public Drawable getWallpaper() {
        throw new UnsupportedOperationException();
    }

    public Drawable peekWallpaper() {
        throw new UnsupportedOperationException();
    }

    public int getWallpaperDesiredMinimumHeight() {
        throw new UnsupportedOperationException();
    }

    public int getWallpaperDesiredMinimumWidth() {
        throw new UnsupportedOperationException();
    }

    public void setWallpaper(Bitmap bitmap) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setWallpaper(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clearWallpaper() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void startActivity(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public void startActivity(Intent intent, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void startActivities(Intent[] intents) {
        throw new UnsupportedOperationException();
    }

    public void startActivities(Intent[] intents, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public void startIntentSender(IntentSender intentSender, Intent intent, int i, int i1, int i2) throws IntentSender.SendIntentException {
        throw new UnsupportedOperationException();
    }

    public void startIntentSender(IntentSender intentSender, Intent intent, int i, int i1, int i2, Bundle bundle) throws IntentSender.SendIntentException {
        throw new UnsupportedOperationException();
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        throw new UnsupportedOperationException();
    }

    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String s, Handler handler) {
        throw new UnsupportedOperationException();
    }

    public void unregisterReceiver(BroadcastReceiver receiver) {
        throw new UnsupportedOperationException();
    }

    public ComponentName startService(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public boolean stopService(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public boolean bindService(Intent service, @NonNull ServiceConnection conn, int flags) {
        throw new UnsupportedOperationException();
    }

    public void unbindService(@NonNull ServiceConnection serviceConnection) {
        throw new UnsupportedOperationException();
    }

    public boolean startInstrumentation(@NonNull ComponentName componentName, String s, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    public String getSystemServiceName(Class<?> aClass) {
        throw new UnsupportedOperationException();
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Context createConfigurationContext(@NonNull Configuration overrideConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Context createDisplayContext(@NonNull Display display) {
        throw new UnsupportedOperationException();
    }

    public boolean isRestricted() {
        throw new UnsupportedOperationException();
    }

    boolean addDatabase(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Database name cannot be empty or null");
        return this.databases.add(name);
    }

    void addRevokedPermission(@NonNull String permission2) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)permission2) ? 1 : 0) != 0, (Object)"permission cannot be null or empty");
        this.revokedPermissions.add(permission2);
    }

    private String getPrefixName(@NonNull String name) {
        Checks.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Name cannot be empty or null");
        return this.prefix + name;
    }
}

