/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.RunnerArgs;
import androidx.test.internal.runner.TestExecutor;
import androidx.test.internal.runner.TestRequestBuilder;
import androidx.test.internal.runner.listener.ActivityFinisherRunListener;
import androidx.test.internal.runner.listener.CoverageListener;
import androidx.test.internal.runner.listener.DelayInjector;
import androidx.test.internal.runner.listener.InstrumentationResultPrinter;
import androidx.test.internal.runner.listener.LogRunListener;
import androidx.test.internal.runner.listener.SuiteAssignmentPrinter;
import androidx.test.internal.runner.tracker.AnalyticsBasedUsageTracker;
import androidx.test.internal.util.ReflectionUtil;
import androidx.test.orchestrator.instrumentationlistener.OrchestratedInstrumentationListener;
import androidx.test.runner.MonitoringInstrumentation;
import androidx.test.runner.UsageTrackerFacilitator;
import androidx.test.runner.lifecycle.ApplicationLifecycleCallback;
import androidx.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import androidx.test.runner.screenshot.Screenshot;
import java.util.HashSet;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation
implements OrchestratedInstrumentationListener.OnConnectListener {
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private Bundle arguments;
    private InstrumentationResultPrinter instrumentationResultPrinter = new InstrumentationResultPrinter();
    private RunnerArgs runnerArgs;
    private UsageTrackerFacilitator usageTrackerFacilitator;
    private OrchestratedInstrumentationListener orchestratorListener;

    public void onCreate(Bundle arguments) {
        this.arguments = arguments;
        this.parseRunnerArgs(this.arguments);
        if (this.waitForDebugger(this.runnerArgs)) {
            Log.i((String)LOG_TAG, (String)"Waiting for debugger to connect...");
            Debug.waitForDebugger();
            Log.i((String)LOG_TAG, (String)"Debugger connected.");
        }
        this.usageTrackerFacilitator = this.isPrimaryInstrProcess(this.runnerArgs.targetProcess) ? new UsageTrackerFacilitator(this.runnerArgs) : new UsageTrackerFacilitator(false);
        super.onCreate(arguments);
        for (ApplicationLifecycleCallback listener : this.runnerArgs.appListeners) {
            ApplicationLifecycleMonitorRegistry.getInstance().addLifecycleCallback(listener);
        }
        this.addScreenCaptureProcessors(this.runnerArgs);
        if (this.runnerArgs.orchestratorService != null && this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)) {
            this.orchestratorListener = new OrchestratedInstrumentationListener(this);
            this.orchestratorListener.connect(this.getContext());
        } else {
            this.start();
        }
    }

    private boolean waitForDebugger(RunnerArgs arguments) {
        return arguments.debug && !arguments.listTestsForOrchestrator;
    }

    @Override
    public void onOrchestratorConnect() {
        this.start();
    }

    private void parseRunnerArgs(Bundle arguments) {
        this.runnerArgs = new RunnerArgs.Builder().fromManifest((Instrumentation)this).fromBundle((Instrumentation)this, arguments).build();
    }

    private Bundle getArguments() {
        return this.arguments;
    }

    @VisibleForTesting
    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.instrumentationResultPrinter;
    }

    public void onStart() {
        this.setJsBridgeClassName("androidx.test.espresso.web.bridge.JavaScriptBridge");
        super.onStart();
        if (this.runnerArgs.listTestsForOrchestrator && this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)) {
            Request testRequest = this.buildRequest(this.runnerArgs, this.getArguments());
            this.orchestratorListener.addTests(testRequest.getRunner().getDescription());
            this.finish(-1, new Bundle());
            return;
        }
        if (this.runnerArgs.remoteMethod != null) {
            ReflectionUtil.reflectivelyInvokeRemoteMethod((String)this.runnerArgs.remoteMethod.testClassName, (String)this.runnerArgs.remoteMethod.methodName);
        }
        if (!this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)) {
            Log.i((String)LOG_TAG, (String)"Runner is idle...");
            return;
        }
        Bundle results = new Bundle();
        try {
            TestExecutor.Builder executorBuilder = new TestExecutor.Builder((Instrumentation)this);
            this.addListeners(this.runnerArgs, executorBuilder);
            Request testRequest = this.buildRequest(this.runnerArgs, this.getArguments());
            results = executorBuilder.build().execute(testRequest);
        }
        catch (RuntimeException e) {
            String msg = "Fatal exception when running tests";
            Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)e);
            String string = String.valueOf("Fatal exception when running tests\n");
            String string2 = String.valueOf(Log.getStackTraceString((Throwable)e));
            results.putString("stream", string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        this.finish(-1, results);
    }

    public void finish(int resultCode, Bundle results) {
        try {
            this.usageTrackerFacilitator.trackUsage(LOG_TAG, "1.3.0-alpha02");
            this.usageTrackerFacilitator.sendUsages();
        }
        catch (RuntimeException re) {
            Log.w((String)LOG_TAG, (String)"Failed to send analytics.", (Throwable)re);
        }
        super.finish(resultCode, results);
    }

    @VisibleForTesting
    final void addListeners(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.newRunListenerMode) {
            this.addListenersNewOrder(args, builder);
        } else {
            this.addListenersLegacyOrder(args, builder);
        }
    }

    private void addListenersLegacyOrder(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            if (this.orchestratorListener != null) {
                builder.addRunListener(this.orchestratorListener);
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                @Override
                public void run() {
                    AndroidJUnitRunner.this.waitForActivitiesToComplete();
                }
            }));
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
        }
        this.addListenersFromArg(args, builder);
    }

    private void addListenersNewOrder(RunnerArgs args, TestExecutor.Builder builder) {
        this.addListenersFromArg(args, builder);
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
            if (this.orchestratorListener != null) {
                builder.addRunListener(this.orchestratorListener);
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                @Override
                public void run() {
                    AndroidJUnitRunner.this.waitForActivitiesToComplete();
                }
            }));
        }
    }

    private void addScreenCaptureProcessors(RunnerArgs args) {
        Screenshot.addScreenCaptureProcessors(new HashSet<ScreenCaptureProcessor>(args.screenCaptureProcessors));
    }

    private void addCoverageListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.codeCoverage) {
            builder.addRunListener(new CoverageListener(args.codeCoveragePath));
        }
    }

    private void addDelayListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.delayInMillis > 0) {
            builder.addRunListener(new DelayInjector(args.delayInMillis));
        } else if (args.logOnly && Build.VERSION.SDK_INT < 16) {
            builder.addRunListener(new DelayInjector(15));
        }
    }

    private void addListenersFromArg(RunnerArgs args, TestExecutor.Builder builder) {
        for (RunListener listener : args.listeners) {
            builder.addRunListener(listener);
        }
    }

    public boolean onException(Object obj, Throwable e) {
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            instResultPrinter.reportProcessCrash(e);
        }
        return super.onException(obj, e);
    }

    @VisibleForTesting
    Request buildRequest(RunnerArgs runnerArgs, Bundle bundleArgs) {
        TestRequestBuilder builder = this.createTestRequestBuilder((Instrumentation)this, bundleArgs);
        builder.addPathsToScan(runnerArgs.classpathToScan);
        if (runnerArgs.classpathToScan.isEmpty()) {
            builder.addPathToScan(this.getContext().getPackageCodePath());
        }
        builder.addFromRunnerArgs(runnerArgs);
        this.registerUserTracker();
        return builder.build();
    }

    private void registerUserTracker() {
        Context targetContext = this.getTargetContext();
        if (targetContext != null) {
            this.usageTrackerFacilitator.registerUsageTracker(new AnalyticsBasedUsageTracker.Builder(targetContext).buildIfPossible());
        }
    }

    TestRequestBuilder createTestRequestBuilder(Instrumentation instr, Bundle arguments) {
        return new TestRequestBuilder(instr, arguments);
    }
}

