/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.instrumentationlistener;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.test.orchestrator.callback.OrchestratorCallback;
import androidx.test.orchestrator.junit.BundleJUnitUtils;
import androidx.test.orchestrator.listeners.OrchestrationListenerManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class OrchestratedInstrumentationListener
extends RunListener {
    private static final String TAG = "OrchestrationListener";
    private static final String ORCHESTRATOR_PACKAGE = "androidx.test.orchestrator";
    private static final String ODO_SERVICE_PACKAGE = "androidx.test.orchestrator.OrchestratorService";
    private final OnConnectListener listener;
    private final ConditionVariable testFinishedCondition = new ConditionVariable();
    private final AtomicBoolean isTestFailed = new AtomicBoolean(false);
    private Description description = Description.EMPTY;
    OrchestratorCallback odoCallback;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            OrchestratedInstrumentationListener.this.odoCallback = OrchestratorCallback.Stub.asInterface(service);
            Log.i((String)OrchestratedInstrumentationListener.TAG, (String)"OrchestrationListener connected to service");
            OrchestratedInstrumentationListener.this.listener.onOrchestratorConnect();
        }

        public void onServiceDisconnected(ComponentName className) {
            OrchestratedInstrumentationListener.this.odoCallback = null;
            Log.i((String)OrchestratedInstrumentationListener.TAG, (String)"OrchestrationListener disconnected from service");
        }
    };

    public OrchestratedInstrumentationListener(OnConnectListener listener) {
        this.listener = listener;
    }

    public void connect(Context context) {
        Intent intent = new Intent(ODO_SERVICE_PACKAGE);
        intent.setPackage(ORCHESTRATOR_PACKAGE);
        if (!context.bindService(intent, this.connection, 1)) {
            throw new RuntimeException("Cannot connect to androidx.test.orchestrator.OrchestratorService");
        }
    }

    public void testRunStarted(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_RUN_STARTED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStarted Status to Orchestrator", (Throwable)e);
        }
    }

    public void testRunFinished(Result result) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_RUN_FINISHED, BundleJUnitUtils.getBundleFromResult(result));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinished Status to Orchestrator", (Throwable)e);
        }
    }

    public void testStarted(Description description) {
        this.testFinishedCondition.close();
        this.isTestFailed.set(false);
        this.description = description;
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_STARTED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestStarted Status to Orchestrator", (Throwable)e);
        }
    }

    public void testFinished(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_FINISHED, BundleJUnitUtils.getBundleFromDescription(description));
            this.testFinishedCondition.open();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinished Status to Orchestrator", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        if (this.isTestFailed.compareAndSet(false, true)) {
            if (Description.TEST_MECHANISM.equals((Object)failure.getDescription())) {
                failure = new Failure(this.description, failure.getException());
            }
            String string = String.valueOf(failure.getException().getMessage());
            Log.d((String)TAG, (String)(string.length() != 0 ? "Sending TestFailure event: ".concat(string) : new String("Sending TestFailure event: ")));
            try {
                this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_FAILURE, BundleJUnitUtils.getBundleFromFailure(failure));
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Unable to send TestFailure status, terminating", e);
            }
        }
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_ASSUMPTION_FAILURE, BundleJUnitUtils.getBundleFromFailure(failure));
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unable to send TestAssumptionFailure status, terminating", e);
        }
    }

    public void testIgnored(Description description) {
        try {
            this.sendTestNotification(OrchestrationListenerManager.TestEvent.TEST_IGNORED, BundleJUnitUtils.getBundleFromDescription(description));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send TestIgnored Status to Orchestrator", (Throwable)e);
        }
    }

    public void sendTestNotification(OrchestrationListenerManager.TestEvent type, Bundle bundle) throws RemoteException {
        if (null == this.odoCallback) {
            throw new IllegalStateException("Unable to send notification, callback is null");
        }
        bundle.putString("TestEvent", type.toString());
        this.odoCallback.sendTestNotification(bundle);
    }

    public void addTests(Description description) {
        if (description.isEmpty()) {
            return;
        }
        if (description.isTest()) {
            String string = description.getClassName();
            String string2 = description.getMethodName();
            this.addTest(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("#").append(string2).toString());
        } else {
            for (Description child : description.getChildren()) {
                this.addTests(child);
            }
        }
    }

    public void addTest(String test) {
        if (null == this.odoCallback) {
            throw new IllegalStateException("Unable to send test, callback is null");
        }
        try {
            this.odoCallback.addTest(test);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to send test", (Throwable)e);
        }
    }

    public void waitUntilTestFinished(long timeoutMs) {
        this.testFinishedCondition.block(timeoutMs);
    }

    public boolean isTestFailed() {
        return this.isTestFailed.get();
    }

    public void reportProcessCrash(Throwable t) {
        this.testFailure(new Failure(this.description, t));
        this.testFinished(this.description);
    }

    public static interface OnConnectListener {
        public void onOrchestratorConnect();
    }
}

