/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.services.events.AnnotationInfo;
import androidx.test.services.events.AnnotationValue;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.internal.StackTrimmer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public final class ParcelableConverter {
    private static final String TAG = "ParcelableConverter";

    private ParcelableConverter() {
    }

    @NonNull
    public static TestCaseInfo getTestCaseFromDescription(@NonNull Description description) throws TestEventException {
        if (!ParcelableConverter.isValidJUnitDescription(description)) {
            String string = String.valueOf(description);
            throw new TestEventException(new StringBuilder(33 + String.valueOf(string).length()).append("Unexpected description instance: ").append(string).toString());
        }
        List<AnnotationInfo> methodAnnotations = ParcelableConverter.getAnnotationsFromCollection(description.getAnnotations());
        List<AnnotationInfo> classAnnotations = description.getTestClass() != null ? ParcelableConverter.getAnnotationsFromArray(description.getTestClass().getAnnotations()) : Collections.emptyList();
        return new TestCaseInfo(description.getClassName(), description.getMethodName() != null ? description.getMethodName() : "", methodAnnotations, classAnnotations);
    }

    public static boolean isValidJUnitDescription(@NonNull Description description) {
        return !description.equals((Object)Description.TEST_MECHANISM);
    }

    @NonNull
    public static List<AnnotationInfo> getAnnotationsFromArray(@NonNull Annotation[] annotations) {
        ArrayList<AnnotationInfo> result = new ArrayList<AnnotationInfo>(annotations.length);
        for (Annotation annotation : annotations) {
            result.add(ParcelableConverter.getAnnotation(annotation));
        }
        return result;
    }

    @NonNull
    public static List<AnnotationInfo> getAnnotationsFromCollection(@NonNull Collection<Annotation> annotations) {
        ArrayList<AnnotationInfo> result = new ArrayList<AnnotationInfo>(annotations.size());
        for (Annotation annotation : annotations) {
            result.add(ParcelableConverter.getAnnotation(annotation));
        }
        return result;
    }

    @NonNull
    public static FailureInfo getFailure(@NonNull Failure junitFailure) throws TestEventException {
        return new FailureInfo(junitFailure.getMessage(), junitFailure.getTestHeader(), StackTrimmer.getTrimmedStackTrace(junitFailure), ParcelableConverter.getTestCaseFromDescription(junitFailure.getDescription()));
    }

    @NonNull
    public static List<FailureInfo> getFailuresFromList(@NonNull List<Failure> failures) throws TestEventException {
        ArrayList<FailureInfo> result = new ArrayList<FailureInfo>();
        for (Failure failure : failures) {
            result.add(ParcelableConverter.getFailure(failure));
        }
        return result;
    }

    @NonNull
    public static AnnotationInfo getAnnotation(@NonNull Annotation javaAnnotation) {
        ArrayList<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>();
        for (Method method : javaAnnotation.annotationType().getDeclaredMethods()) {
            AnnotationValue annotationValue = ParcelableConverter.getAnnotationValue(javaAnnotation, method);
            annotationValues.add(annotationValue);
        }
        return new AnnotationInfo(javaAnnotation.annotationType().getName(), annotationValues);
    }

    @NonNull
    private static AnnotationValue getAnnotationValue(@NonNull Annotation javaAnnotation, @NonNull Method annotationField) {
        List<String> annotationFieldValues;
        String annotationFieldName = annotationField.getName();
        String valueType = "NULL";
        try {
            Object fieldValues = annotationField.invoke((Object)javaAnnotation, (Object[])null);
            valueType = ParcelableConverter.getFieldValuesType(fieldValues);
            annotationFieldValues = ParcelableConverter.getArrayElements(fieldValues);
        }
        catch (Exception e) {
            String string = String.valueOf(javaAnnotation);
            Log.e((String)TAG, (String)new StringBuilder(48 + String.valueOf(annotationFieldName).length() + String.valueOf(string).length()).append("Unable to get annotation values for field '").append(annotationFieldName).append("': [").append(string).append("]").toString(), (Throwable)e);
            annotationFieldValues = new ArrayList<String>();
        }
        return new AnnotationValue(annotationFieldName, annotationFieldValues, valueType);
    }

    @NonNull
    private static String getFieldValuesType(Object fieldValues) {
        return fieldValues.getClass().getSimpleName().replace("[", "").replace("]", "");
    }

    @NonNull
    static List<String> getArrayElements(@Nullable Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        if (obj == null) {
            result.add("<null>");
        } else if (obj.getClass().isArray()) {
            for (int n = 0; n < Array.getLength(obj); ++n) {
                result.add(Array.get(obj, n).toString());
            }
        } else if (obj instanceof Iterable) {
            for (Object element : (Iterable)obj) {
                result.add(element.toString());
            }
        } else {
            result.add(obj.toString());
        }
        return result;
    }
}

