/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private volatile Test fTest;

    private static String createSuiteDescription(TestSuite ts) {
        int count = ts.countTestCases();
        String example = count == 0 ? "" : String.format(" [example: %s]", ts.testAt(0));
        return String.format("TestSuite with %s tests%s", count, example);
    }

    private Test getTest() {
        return this.fTest;
    }

    public TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    public Description getDescription() {
        return JUnit38ClassRunner.makeDescription(this.getTest());
    }

    static Description makeDescription(Test test) {
        if (test instanceof TestCase) {
            TestCase tc = (TestCase)test;
            return Description.createTestDescription(tc.getClass(), (String)tc.getName(), (Annotation[])JUnit38ClassRunner.getAnnotations(tc));
        }
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            String name = ts.getName() == null ? JUnit38ClassRunner.createSuiteDescription(ts) : ts.getName();
            Description description = Description.createSuiteDescription((String)name, (Annotation[])new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                Description made = JUnit38ClassRunner.makeDescription(ts.testAt(i));
                description.addChild(made);
            }
            return description;
        }
        if (test instanceof Describable) {
            Describable adapter = (Describable)test;
            return adapter.getDescription();
        }
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            return JUnit38ClassRunner.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test.getClass());
    }

    public JUnit38ClassRunner(Class<?> klass) {
        this((Test)new TestSuite(klass.asSubclass(TestCase.class)));
    }

    public JUnit38ClassRunner(Test test) {
        this.setTest(test);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.getTest() instanceof Filterable) {
            Filterable adapter = (Filterable)this.getTest();
            adapter.filter(filter);
        } else if (this.getTest() instanceof TestSuite) {
            TestSuite suite = (TestSuite)this.getTest();
            TestSuite filtered = new TestSuite(suite.getName());
            int n = suite.testCount();
            for (int i = 0; i < n; ++i) {
                Test test = suite.testAt(i);
                if (!filter.shouldRun(JUnit38ClassRunner.makeDescription(test))) continue;
                filtered.addTest(test);
            }
            this.setTest((Test)filtered);
            if (filtered.testCount() == 0) {
                throw new NoTestsRemainException();
            }
        }
    }

    public void run(RunNotifier notifier) {
        TestResult result = new TestResult();
        result.addListener(this.createAdaptingListener(notifier));
        this.getTest().run(result);
    }

    private void setTest(Test test) {
        this.fTest = test;
    }

    public void sort(Sorter sorter) {
        if (this.getTest() instanceof Sortable) {
            Sortable adapter = (Sortable)this.getTest();
            adapter.sort(sorter);
        }
    }

    private static Annotation[] getAnnotations(TestCase test) {
        try {
            Method m = test.getClass().getMethod(test.getName(), new Class[0]);
            return m.getDeclaredAnnotations();
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Annotation[0];
    }

    private static final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;
        private Test currentTest = null;
        private Description description = null;

        private Class<? extends Test> getEffectiveClass(Test test) {
            return test.getClass();
        }

        private Description asDescription(Test test) {
            if (this.currentTest != null && this.currentTest.equals(test) && this.description != null) {
                return this.description;
            }
            this.currentTest = test;
            if (test instanceof Describable) {
                Describable facade = (Describable)test;
                this.description = facade.getDescription();
            } else {
                this.description = test instanceof TestCase ? JUnit38ClassRunner.makeDescription(test) : Description.createTestDescription(this.getEffectiveClass(test), (String)test.toString());
            }
            return this.description;
        }

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void addError(Test test, Throwable t) {
            Failure failure = new Failure(this.asDescription(test), t);
            this.fNotifier.fireTestFailure(failure);
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.addError(test, (Throwable)t);
        }

        public void endTest(Test test) {
            this.fNotifier.fireTestFinished(this.asDescription(test));
        }

        public void startTest(Test test) {
            this.fNotifier.fireTestStarted(this.asDescription(test));
        }
    }
}

