/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4.statement;

import android.os.Looper;
import android.util.Log;
import androidx.test.platform.app.InstrumentationRegistry;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UiThreadStatement
extends Statement {
    private static final String TAG = "UiThreadStatement";
    private final Statement base;
    private final boolean runOnUiThread;

    private static Class<? extends Annotation> loadUiThreadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public UiThreadStatement(Statement base, boolean runOnUiThread) {
        this.base = base;
        this.runOnUiThread = runOnUiThread;
    }

    public void evaluate() throws Throwable {
        if (this.runOnUiThread) {
            final AtomicReference exceptionRef = new AtomicReference();
            UiThreadStatement.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        UiThreadStatement.this.base.evaluate();
                    }
                    catch (Throwable throwable) {
                        exceptionRef.set(throwable);
                    }
                }
            });
            Throwable throwable = (Throwable)exceptionRef.get();
            if (throwable != null) {
                throw throwable;
            }
        } else {
            this.base.evaluate();
        }
    }

    public static void runOnUiThread(Runnable runnable) throws Throwable {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.w((String)TAG, (String)"Already on the UI thread, this method should not be called from the main application thread");
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            InstrumentationRegistry.getInstrumentation().runOnMainSync(task);
            try {
                task.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    private static boolean classHasAnnotation(FrameworkMethod method, Class<? extends Annotation> annotationClass) {
        Class declaringClass = method.getDeclaringClass();
        for (Class<?> declaredInterface : declaringClass.getInterfaces()) {
            if (!declaredInterface.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        while (declaringClass != null) {
            if (declaringClass.isAnnotationPresent(annotationClass)) {
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        return false;
    }

    private static boolean hasAnnotation(FrameworkMethod method, Class<? extends Annotation> annotationClass) {
        return annotationClass != null && (method.getAnnotation(annotationClass) != null || UiThreadStatement.classHasAnnotation(method, annotationClass));
    }

    public boolean isRunOnUiThread() {
        return this.runOnUiThread;
    }

    public static boolean shouldRunOnUiThread(FrameworkMethod method) {
        Class<? extends Annotation> deprecatedUiThreadTestClass = UiThreadStatement.loadUiThreadClass("android.test.UiThreadTest");
        if (UiThreadStatement.hasAnnotation(method, deprecatedUiThreadTestClass)) {
            return true;
        }
        Class<? extends Annotation> uiThreadTestClass = UiThreadStatement.loadUiThreadClass("androidx.test.annotation.UiThreadTest");
        return UiThreadStatement.hasAnnotation(method, deprecatedUiThreadTestClass) || UiThreadStatement.hasAnnotation(method, uiThreadTestClass);
    }
}

