/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.runner.permission.RequestPermissionCallable$$ExternalSyntheticBackport0;
import androidx.test.runner.permission.ShellCommand;
import java.util.Arrays;
import java.util.concurrent.Callable;

@VisibleForTesting
@ExperimentalTestApi
public abstract class RequestPermissionCallable
implements Callable<Result> {
    private final ShellCommand shellCommand;
    private final Context targetContext;
    private final String targetPackage;
    private final String permission;

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.targetPackage, this.permission});
    }

    protected ShellCommand getShellCommand() {
        return this.shellCommand;
    }

    protected String getPermission() {
        return this.permission;
    }

    public RequestPermissionCallable(@NonNull ShellCommand shellCommand, @NonNull Context targetContext, String permission) {
        this.shellCommand = (ShellCommand)Checks.checkNotNull((Object)shellCommand, (Object)"shellCommand cannot be null!");
        this.targetContext = (Context)Checks.checkNotNull((Object)targetContext, (Object)"targetContext cannot be null!");
        String targetPackage = this.targetContext.getPackageName();
        Checks.checkState((!TextUtils.isEmpty((CharSequence)targetPackage) ? 1 : 0) != 0, (Object)"targetPackage cannot be empty or null!");
        this.targetPackage = targetPackage;
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPermissionCallable that = (RequestPermissionCallable)o;
        return RequestPermissionCallable$$ExternalSyntheticBackport0.m(this.targetPackage, that.targetPackage) && RequestPermissionCallable$$ExternalSyntheticBackport0.m(this.permission, that.permission);
    }

    protected boolean isPermissionGranted() {
        return 0 == this.targetContext.checkCallingOrSelfPermission(this.permission);
    }

    public static enum Result {
        SUCCESS,
        FAILURE;

    }
}

