/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.screenshot;

import android.os.Build;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.runner.screenshot.ScreenCapture;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

@ExperimentalTestApi
public class BasicScreenCaptureProcessor
implements ScreenCaptureProcessor {
    private static int sAndroidRuntimeVersion = Build.VERSION.SDK_INT;
    private static String sAndroidDeviceName = Build.DEVICE;
    protected String mTag = "BasicScreenCaptureProcessor";
    protected String mFileNameDelimiter = "-";
    protected String mDefaultFilenamePrefix = "screenshot";
    protected File mDefaultScreenshotPath;

    protected String getDefaultFilename() {
        int n = sAndroidRuntimeVersion;
        String string = this.mFileNameDelimiter;
        String string2 = sAndroidDeviceName;
        String string3 = this.mFileNameDelimiter;
        String string4 = this.mDefaultFilenamePrefix;
        return this.getFilename(string4 + string3 + string2 + string + n);
    }

    protected String getFilename(String prefix) {
        String string = String.valueOf(UUID.randomUUID());
        String string2 = this.mFileNameDelimiter;
        String string3 = prefix;
        return string3 + string2 + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ScreenCapture capture) throws IOException {
        String filename = capture.getName() == null ? this.getDefaultFilename() : this.getFilename(capture.getName());
        String string = capture.getFormat().toString().toLowerCase();
        String string2 = filename;
        filename = string2 + "." + string;
        File imageFolder = this.mDefaultScreenshotPath;
        imageFolder.mkdirs();
        if (!imageFolder.isDirectory() && !imageFolder.canWrite()) {
            throw new IOException(String.format("The directory %s does not exist and could not be created or is not writable.", imageFolder));
        }
        File imageFile = new File(imageFolder, filename);
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(imageFile));
            capture.getBitmap().compress(capture.getFormat(), 100, (OutputStream)out);
            ((BufferedOutputStream)out).flush();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Log.e((String)this.mTag, (String)"Could not close output steam.", (Throwable)e);
            }
        }
        return filename;
    }

    public BasicScreenCaptureProcessor() {
        this(new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "screenshots"));
    }

    BasicScreenCaptureProcessor(File defaultScreenshotPath) {
        this.mDefaultScreenshotPath = defaultScreenshotPath;
    }

    @VisibleForTesting
    static void setAndroidDeviceName(String deviceName) {
        sAndroidDeviceName = deviceName;
    }

    @VisibleForTesting
    static void setAndroidRuntimeVersion(int sdkInt) {
        sAndroidRuntimeVersion = sdkInt;
    }
}

