/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.screenshot;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.runner.screenshot.BasicScreenCaptureProcessor;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

@ExperimentalTestApi
public final class ScreenCapture {
    private static final Bitmap.CompressFormat DEFAULT_FORMAT = Bitmap.CompressFormat.PNG;
    private final Bitmap bitmap;
    private ScreenCaptureProcessor defaultProcessor = new BasicScreenCaptureProcessor();
    private String filename;
    private Bitmap.CompressFormat format;
    private Set<ScreenCaptureProcessor> processorSet = new HashSet<ScreenCaptureProcessor>();

    public int hashCode() {
        int prime = 37;
        int result = 1;
        if (this.bitmap != null) {
            result = 37 * result + this.bitmap.hashCode();
        }
        if (this.format != null) {
            result = 37 * result + this.format.hashCode();
        }
        if (this.filename != null) {
            result = 37 * result + this.filename.hashCode();
        }
        if (!this.processorSet.isEmpty()) {
            result = 37 * result + this.processorSet.hashCode();
        }
        return result;
    }

    public Bitmap.CompressFormat getFormat() {
        return this.format;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public ScreenCapture setFormat(Bitmap.CompressFormat format) {
        this.format = format;
        return this;
    }

    public ScreenCapture setName(String filename) {
        this.filename = filename;
        return this;
    }

    ScreenCapture setProcessors(@NonNull Set<ScreenCaptureProcessor> processorSet) {
        this.processorSet = (Set)Checks.checkNotNull(processorSet);
        return this;
    }

    public String getName() {
        return this.filename;
    }

    Set<ScreenCaptureProcessor> getProcessors() {
        return this.processorSet;
    }

    ScreenCapture(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.format = DEFAULT_FORMAT;
    }

    ScreenCapture(Bitmap bitmap, ScreenCaptureProcessor defaultProcessor) {
        this.bitmap = bitmap;
        this.format = DEFAULT_FORMAT;
        this.defaultProcessor = defaultProcessor;
    }

    public void process() throws IOException {
        this.process(this.processorSet);
    }

    public void process(@NonNull Set<ScreenCaptureProcessor> processorSet) throws IOException {
        Checks.checkNotNull(processorSet);
        if (processorSet.isEmpty()) {
            this.defaultProcessor.process(this);
            return;
        }
        for (ScreenCaptureProcessor processor : processorSet) {
            processor.process(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScreenCapture)) {
            return false;
        }
        ScreenCapture other = (ScreenCapture)obj;
        boolean bitmapsEqual = this.bitmap == null ? other.getBitmap() == null : this.getBitmap().sameAs(other.getBitmap());
        boolean nameEqual = this.filename == null ? other.getName() == null : this.filename.equals(other.getName());
        boolean formatEqual = this.format == null ? other.getFormat() == null : this.format.equals((Object)other.getFormat());
        return bitmapsEqual && nameEqual && formatEqual && this.processorSet.containsAll(other.getProcessors()) && other.getProcessors().containsAll(this.processorSet);
    }
}

