/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.screenshot;

import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.test.runner.screenshot.TakeScreenshotCallable-IA;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

final class TakeScreenshotCallable
implements Callable<Bitmap> {
    private static final String TAG = "TakeScreenshotCallable";
    private WeakReference<View> viewRef;

    @Override
    public Bitmap call() {
        Bitmap bitmap = null;
        ((View)this.viewRef.get()).setDrawingCacheEnabled(true);
        try {
            bitmap = Bitmap.createBitmap((Bitmap)((View)this.viewRef.get()).getDrawingCache());
        }
        catch (OutOfMemoryError omm) {
            Log.e((String)TAG, (String)"Out of memory exception while trying to take a screenshot.", (Throwable)omm);
        }
        finally {
            ((View)this.viewRef.get()).setDrawingCacheEnabled(false);
        }
        return bitmap;
    }

    private TakeScreenshotCallable(View view) {
        this.viewRef = new WeakReference<View>(view);
    }

    /* synthetic */ TakeScreenshotCallable(View view, TakeScreenshotCallable-IA takeScreenshotCallable-IA) {
        this(view);
    }

    @VisibleForTesting
    static class Factory {
        Callable<Bitmap> create(View view) {
            return new TakeScreenshotCallable(view, null);
        }

        Factory() {
        }
    }
}

