/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.annotation.Nullable;
import androidx.test.internal.runner.DirectTestLoader;
import androidx.test.internal.runner.ScanningTestLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

public abstract class TestLoader {
    public List<Runner> getRunnersFor(Collection<String> classNames) {
        LinkedHashMap<String, Runner> runnersMap = new LinkedHashMap<String, Runner>();
        for (String className : classNames) {
            Runner runner;
            if (runnersMap.containsKey(className) || (runner = this.doCreateRunner(className)) == null) continue;
            runnersMap.put(className, runner);
        }
        return new ArrayList<Runner>(runnersMap.values());
    }

    protected abstract Runner doCreateRunner(String var1);

    public static class Factory {
        public static TestLoader create(@Nullable ClassLoader classLoader, RunnerBuilder runnerBuilder, boolean scanningPath) {
            if (classLoader == null) {
                classLoader = TestLoader.class.getClassLoader();
            }
            if (scanningPath) {
                return new ScanningTestLoader(classLoader, runnerBuilder);
            }
            return new DirectTestLoader(classLoader, runnerBuilder);
        }

        private Factory() {
        }
    }
}

