/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.suites;

import androidx.annotation.RestrictTo;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.runner.ClassPathScanner;
import androidx.test.internal.runner.ErrorReportingRunner;
import androidx.test.internal.runner.TestLoader;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

@ExperimentalTestApi
public final class PackagePrefixClasspathSuite
extends Suite {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public PackagePrefixClasspathSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, PackagePrefixClasspathSuite.getRunnersForClasses(klass, builder));
    }

    private static List<Runner> getRunnersForClasses(Class<?> klass, RunnerBuilder builder) {
        try {
            ClassPathScanner.ChainedClassNameFilter filter = new ClassPathScanner.ChainedClassNameFilter();
            filter.add(new ClassPathScanner.InclusivePackageNamesFilter(Arrays.asList(klass.getPackage().getName())));
            filter.add(new ClassPathScanner.ExternalClassNameFilter());
            Set<String> classNames = new ClassPathScanner(ClassPathScanner.getDefaultClasspaths(InstrumentationRegistry.getInstrumentation())).getClassPathEntries(filter);
            classNames.remove(klass.getName());
            return TestLoader.Factory.create(null, builder, true).getRunnersFor(classNames);
        }
        catch (IOException e) {
            return Arrays.asList(new Runner[]{new ErrorReportingRunner(InstrumentationRegistry.getInstrumentation().getContext().getPackageName(), new RuntimeException("Failed to perform classpath scanning to determine tests to run", e))});
        }
    }
}

