/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.compose.foundation;

import androidx.compose.ui.layout.Measurable;
import androidx.wear.compose.foundation.BaseSizeWrapper;
import androidx.wear.compose.foundation.CurvedChild;
import androidx.wear.compose.foundation.CurvedLayoutKt;
import androidx.wear.compose.foundation.CurvedMeasureScope;
import androidx.wear.compose.foundation.PartialLayoutInfo;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Landroidx/wear/compose/foundation/SweepSizeWrapper;", "Landroidx/wear/compose/foundation/BaseSizeWrapper;", "child", "Landroidx/wear/compose/foundation/CurvedChild;", "minSweepDegrees", "", "maxSweepDegrees", "minThickness", "Landroidx/compose/ui/unit/Dp;", "maxThickness", "(Landroidx/wear/compose/foundation/CurvedChild;FFFFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMaxSweepDegrees", "()F", "getMinSweepDegrees", "calculateSweepRadians", "partialLayoutInfo", "Landroidx/wear/compose/foundation/PartialLayoutInfo;", "initializeMeasure", "", "Landroidx/wear/compose/foundation/CurvedMeasureScope;", "measurables", "", "Landroidx/compose/ui/layout/Measurable;", "compose-foundation_release"})
public final class SweepSizeWrapper
extends BaseSizeWrapper {
    private final float minSweepDegrees;
    private final float maxSweepDegrees;

    private SweepSizeWrapper(CurvedChild child, float minSweepDegrees, float maxSweepDegrees, float minThickness, float maxThickness) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        super(child, minThickness, maxThickness, null);
        this.minSweepDegrees = minSweepDegrees;
        this.maxSweepDegrees = maxSweepDegrees;
    }

    public final float getMinSweepDegrees() {
        return this.minSweepDegrees;
    }

    public final float getMaxSweepDegrees() {
        return this.maxSweepDegrees;
    }

    @Override
    public void initializeMeasure(@NotNull CurvedMeasureScope $this$initializeMeasure, @NotNull Iterator<? extends Measurable> measurables) {
        Intrinsics.checkNotNullParameter((Object)$this$initializeMeasure, (String)"<this>");
        Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
        this.baseInitializeMeasure($this$initializeMeasure, measurables);
    }

    @Override
    protected float calculateSweepRadians(@NotNull PartialLayoutInfo partialLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)partialLayoutInfo, (String)"partialLayoutInfo");
        return RangesKt.coerceIn((float)partialLayoutInfo.getSweepRadians(), (float)CurvedLayoutKt.toRadians(this.minSweepDegrees), (float)CurvedLayoutKt.toRadians(this.maxSweepDegrees));
    }

    public /* synthetic */ SweepSizeWrapper(CurvedChild child, float minSweepDegrees, float maxSweepDegrees, float minThickness, float maxThickness, DefaultConstructorMarker $constructor_marker) {
        this(child, minSweepDegrees, maxSweepDegrees, minThickness, maxThickness);
    }
}

