/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.compose.foundation.lazy;

import androidx.annotation.RestrictTo;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.ui.util.MathHelpersKt;
import androidx.wear.compose.foundation.lazy.AutoCenteringParams;
import androidx.wear.compose.foundation.lazy.DefaultScalingLazyListItemInfo;
import androidx.wear.compose.foundation.lazy.ScaleAndAlpha;
import androidx.wear.compose.foundation.lazy.ScalingLazyListAnchorType;
import androidx.wear.compose.foundation.lazy.ScalingLazyListItemInfo;
import androidx.wear.compose.foundation.lazy.ScalingParams;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\t\u001ag\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0000\u001a=\u0010\u001a\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0007\u001a!\u0010%\u001a\u00020!*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'\u001a!\u0010(\u001a\u00020!*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010'\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006*"}, d2={"calculateItemInfo", "Landroidx/wear/compose/foundation/lazy/ScalingLazyListItemInfo;", "itemStart", "", "item", "Landroidx/compose/foundation/lazy/LazyListItemInfo;", "verticalAdjustment", "viewportHeightPx", "viewportCenterLinePx", "scalingParams", "Landroidx/wear/compose/foundation/lazy/ScalingParams;", "beforeContentPaddingPx", "anchorType", "Landroidx/wear/compose/foundation/lazy/ScalingLazyListAnchorType;", "autoCentering", "Landroidx/wear/compose/foundation/lazy/AutoCenteringParams;", "visible", "", "calculateItemInfo-tAyFXGY", "(ILandroidx/compose/foundation/lazy/LazyListItemInfo;IIILandroidx/wear/compose/foundation/lazy/ScalingParams;IILandroidx/wear/compose/foundation/lazy/AutoCenteringParams;Z)Landroidx/wear/compose/foundation/lazy/ScalingLazyListItemInfo;", "calculateScaleAndAlpha", "Landroidx/wear/compose/foundation/lazy/ScaleAndAlpha;", "viewPortStartPx", "viewPortEndPx", "itemTopPx", "itemBottomPx", "convertToCenterOffset", "itemScrollOffset", "beforeContentPaddingInPx", "itemSizeInPx", "convertToCenterOffset-mLh2Qhg", "(IIIII)I", "inverseLerp", "", "start", "stop", "value", "startOffset", "startOffset-w3akWxg", "(Landroidx/wear/compose/foundation/lazy/ScalingLazyListItemInfo;I)F", "unadjustedStartOffset", "unadjustedStartOffset-w3akWxg", "compose-foundation_release"})
public final class ScalingLazyColumnMeasureKt {
    @NotNull
    public static final ScaleAndAlpha calculateScaleAndAlpha(int viewPortStartPx, int viewPortEndPx, int itemTopPx, int itemBottomPx, @NotNull ScalingParams scalingParams2) {
        Intrinsics.checkNotNullParameter((Object)scalingParams2, (String)"scalingParams");
        float scaleToApply = 1.0f;
        float alphaToApply = 1.0f;
        float itemHeightPx = itemBottomPx - itemTopPx;
        float viewPortHeightPx = viewPortEndPx - viewPortStartPx;
        if (viewPortHeightPx > 0.0f) {
            int itemEdgeDistanceFromViewPortEdge = Math.min(viewPortEndPx - itemTopPx, itemBottomPx - viewPortStartPx);
            float itemEdgeAsFractionOfViewPort = (float)itemEdgeDistanceFromViewPortEdge / viewPortHeightPx;
            float heightAsFractionOfViewPort = itemHeightPx / viewPortHeightPx;
            float sizeRatio = ScalingLazyColumnMeasureKt.inverseLerp(scalingParams2.getMinElementHeight(), scalingParams2.getMaxElementHeight(), heightAsFractionOfViewPort);
            float scalingLineAsFractionOfViewPort = MathHelpersKt.lerp((float)scalingParams2.getMinTransitionArea(), (float)scalingParams2.getMaxTransitionArea(), (float)sizeRatio);
            if (itemEdgeAsFractionOfViewPort < scalingLineAsFractionOfViewPort) {
                float scalingProgressRaw = 1.0f - itemEdgeAsFractionOfViewPort / scalingLineAsFractionOfViewPort;
                float scalingInterpolated = scalingParams2.getScaleInterpolator().transform(scalingProgressRaw);
                scaleToApply = MathHelpersKt.lerp((float)1.0f, (float)scalingParams2.getEdgeScale(), (float)scalingInterpolated);
                alphaToApply = MathHelpersKt.lerp((float)1.0f, (float)scalingParams2.getEdgeAlpha(), (float)scalingInterpolated);
            }
        }
        return new ScaleAndAlpha(scaleToApply, alphaToApply);
    }

    @NotNull
    public static final ScalingLazyListItemInfo calculateItemInfo-tAyFXGY(int itemStart, @NotNull LazyListItemInfo item2, int verticalAdjustment, int viewportHeightPx, int viewportCenterLinePx, @NotNull ScalingParams scalingParams2, int beforeContentPaddingPx, int anchorType, @Nullable AutoCenteringParams autoCentering, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter((Object)scalingParams2, (String)"scalingParams");
        int adjustedItemStart = itemStart - verticalAdjustment;
        int adjustedItemEnd = itemStart + item2.getSize() - verticalAdjustment;
        ScaleAndAlpha scaleAndAlpha = ScalingLazyColumnMeasureKt.calculateScaleAndAlpha(0, viewportHeightPx, adjustedItemStart, adjustedItemEnd, scalingParams2);
        boolean isAboveLine = adjustedItemEnd + adjustedItemStart < viewportHeightPx;
        int scaledHeight = MathKt.roundToInt((float)((float)item2.getSize() * scaleAndAlpha.getScale()));
        int scaledItemTop = !isAboveLine ? itemStart : itemStart + item2.getSize() - scaledHeight;
        int offset = ScalingLazyColumnMeasureKt.convertToCenterOffset-mLh2Qhg(anchorType, scaledItemTop, viewportCenterLinePx, beforeContentPaddingPx, scaledHeight);
        int unadjustedOffset = ScalingLazyColumnMeasureKt.convertToCenterOffset-mLh2Qhg(anchorType, item2.getOffset(), viewportCenterLinePx, beforeContentPaddingPx, item2.getSize());
        return new DefaultScalingLazyListItemInfo(autoCentering != null ? item2.getIndex() - 1 : item2.getIndex(), item2.getKey(), unadjustedOffset, offset, scaledHeight, scaleAndAlpha.getScale(), visible ? scaleAndAlpha.getAlpha() : 0.0f, item2.getSize());
    }

    public static final int convertToCenterOffset-mLh2Qhg(int anchorType, int itemScrollOffset, int viewportCenterLinePx, int beforeContentPaddingInPx, int itemSizeInPx) {
        return itemScrollOffset - viewportCenterLinePx + beforeContentPaddingInPx + (ScalingLazyListAnchorType.equals-impl0(anchorType, ScalingLazyListAnchorType.Companion.getItemStart-ZuIr4RU()) ? 0 : itemSizeInPx / 2);
    }

    public static final float startOffset-w3akWxg(@NotNull ScalingLazyListItemInfo $this$startOffset_u2dw3akWxg, int anchorType) {
        Intrinsics.checkNotNullParameter((Object)$this$startOffset_u2dw3akWxg, (String)"$this$startOffset");
        return (float)$this$startOffset_u2dw3akWxg.getOffset() - (ScalingLazyListAnchorType.equals-impl0(anchorType, ScalingLazyListAnchorType.Companion.getItemCenter-ZuIr4RU()) ? (float)$this$startOffset_u2dw3akWxg.getSize() / 2.0f : 0.0f);
    }

    public static final float unadjustedStartOffset-w3akWxg(@NotNull ScalingLazyListItemInfo $this$unadjustedStartOffset_u2dw3akWxg, int anchorType) {
        Intrinsics.checkNotNullParameter((Object)$this$unadjustedStartOffset_u2dw3akWxg, (String)"$this$unadjustedStartOffset");
        return (float)$this$unadjustedStartOffset_u2dw3akWxg.getUnadjustedOffset() - (ScalingLazyListAnchorType.equals-impl0(anchorType, ScalingLazyListAnchorType.Companion.getItemCenter-ZuIr4RU()) ? (float)$this$unadjustedStartOffset_u2dw3akWxg.getUnadjustedSize() / 2.0f : 0.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final float inverseLerp(float start, float stop, float value) {
        return RangesKt.coerceIn((float)((value - start) / (stop - start)), (float)0.0f, (float)1.0f);
    }
}

