/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.Clock;
import androidx.work.Logger;
import androidx.work.impl.Scheduler;
import androidx.work.impl.background.gcm.GcmTaskConverter;
import androidx.work.impl.background.gcm.WorkManagerGcmService;
import androidx.work.impl.model.WorkSpec;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.Task;

public class GcmScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix((String)"GcmScheduler");
    private final GcmNetworkManager mNetworkManager;
    private final GcmTaskConverter mTaskConverter;

    public GcmScheduler(@NonNull Context context, @NonNull Clock clock) {
        boolean isPlayServicesAvailable;
        boolean bl = isPlayServicesAvailable = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        if (!isPlayServicesAvailable) {
            throw new IllegalStateException("Google Play Services not available");
        }
        this.mNetworkManager = GcmNetworkManager.getInstance((Context)context);
        this.mTaskConverter = new GcmTaskConverter(clock);
    }

    public void schedule(WorkSpec ... workSpecs) {
        for (WorkSpec workSpec : workSpecs) {
            OneoffTask task = this.mTaskConverter.convert(workSpec);
            Logger.get().debug(TAG, "Scheduling " + workSpec + "with " + task);
            this.mNetworkManager.schedule((Task)task);
        }
    }

    public void cancel(@NonNull String workSpecId) {
        Logger.get().debug(TAG, "Cancelling " + workSpecId);
        this.mNetworkManager.cancelTask(workSpecId, WorkManagerGcmService.class);
    }

    public boolean hasLimitedSchedulingSlots() {
        return true;
    }
}

