/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Processor;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpec;
import com.google.android.gms.gcm.TaskParams;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WorkManagerGcmDispatcher {
    static final String TAG = Logger.tagWithPrefix((String)"WrkMgrGcmDispatcher");
    private static final long AWAIT_TIME_IN_MINUTES = 10L;
    WorkManagerImpl mWorkManagerImpl;

    public WorkManagerGcmDispatcher(@NonNull Context context) {
        this.mWorkManagerImpl = WorkManagerImpl.getInstance((Context)context);
    }

    @MainThread
    public void onInitializeTasks() {
        this.mWorkManagerImpl.getWorkTaskExecutor().executeOnBackgroundThread(new Runnable(){

            @Override
            public void run() {
                Logger.get().debug(TAG, "onInitializeTasks(): Rescheduling work", new Throwable[0]);
                WorkManagerGcmDispatcher.this.mWorkManagerImpl.rescheduleEligibleWork();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onRunTask(@NonNull TaskParams taskParams) {
        WorkInfo.State state;
        Logger.get().debug(TAG, String.format("Handling task %s", taskParams), new Throwable[0]);
        String workSpecId = taskParams.getTag();
        if (workSpecId == null || workSpecId.isEmpty()) {
            Logger.get().debug(TAG, "Bad request. No workSpecId.", new Throwable[0]);
            return 2;
        }
        WorkSpecExecutionListener listener = new WorkSpecExecutionListener(workSpecId);
        Processor processor = this.mWorkManagerImpl.getProcessor();
        processor.addExecutionListener((ExecutionListener)listener);
        this.mWorkManagerImpl.startWork(workSpecId);
        try {
            listener.getLatch().await(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException exception) {
            Logger.get().debug(TAG, String.format("Rescheduling WorkSpec %s", workSpecId), new Throwable[0]);
            int n = this.reschedule(workSpecId);
            return n;
        }
        finally {
            processor.removeExecutionListener((ExecutionListener)listener);
        }
        if (listener.needsReschedule()) {
            Logger.get().debug(TAG, String.format("Rescheduling WorkSpec %s", workSpecId), new Throwable[0]);
            return this.reschedule(workSpecId);
        }
        WorkDatabase workDatabase = this.mWorkManagerImpl.getWorkDatabase();
        WorkSpec workSpec = workDatabase.workSpecDao().getWorkSpec(workSpecId);
        WorkInfo.State state2 = state = workSpec != null ? workSpec.state : null;
        if (state == null) {
            Logger.get().debug(TAG, String.format("WorkSpec %s does not exist", workSpecId), new Throwable[0]);
            return 2;
        }
        switch (state) {
            case SUCCEEDED: 
            case CANCELLED: {
                Logger.get().debug(TAG, String.format("Returning RESULT_SUCCESS for WorkSpec %s", workSpecId), new Throwable[0]);
                return 0;
            }
            case FAILED: {
                Logger.get().debug(TAG, String.format("Returning RESULT_FAILURE for WorkSpec %s", workSpecId), new Throwable[0]);
                return 2;
            }
        }
        Logger.get().debug(TAG, "Rescheduling eligible work.", new Throwable[0]);
        return this.reschedule(workSpecId);
    }

    private int reschedule(@NonNull String workSpecId) {
        WorkDatabase workDatabase = this.mWorkManagerImpl.getWorkDatabase();
        workDatabase.beginTransaction();
        try {
            workDatabase.workSpecDao().markWorkSpecScheduled(workSpecId, -1L);
            Schedulers.schedule((Configuration)this.mWorkManagerImpl.getConfiguration(), (WorkDatabase)this.mWorkManagerImpl.getWorkDatabase(), (List)this.mWorkManagerImpl.getSchedulers());
            workDatabase.setTransactionSuccessful();
        }
        finally {
            workDatabase.endTransaction();
        }
        Logger.get().debug(TAG, String.format("Returning RESULT_SUCCESS for WorkSpec %s", workSpecId), new Throwable[0]);
        return 0;
    }

    static class WorkSpecExecutionListener
    implements ExecutionListener {
        private static final String TAG = Logger.tagWithPrefix((String)"WorkSpecExecutionListener");
        private final String mWorkSpecId;
        private final CountDownLatch mLatch;
        private boolean mNeedsReschedule;

        WorkSpecExecutionListener(@NonNull String workSpecId) {
            this.mWorkSpecId = workSpecId;
            this.mLatch = new CountDownLatch(1);
            this.mNeedsReschedule = false;
        }

        boolean needsReschedule() {
            return this.mNeedsReschedule;
        }

        CountDownLatch getLatch() {
            return this.mLatch;
        }

        public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
            if (!this.mWorkSpecId.equals(workSpecId)) {
                Logger.get().warning(TAG, String.format("Notified for %s, but was looking for %s", workSpecId, this.mWorkSpecId), new Throwable[0]);
            } else {
                this.mNeedsReschedule = needsReschedule;
                this.mLatch.countDown();
            }
        }
    }
}

