/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import android.content.Context;
import android.os.Bundle;
import android.os.PowerManager;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Processor;
import androidx.work.impl.Schedulers;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.StartStopTokens;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.WorkTimer;
import com.google.android.gms.gcm.TaskParams;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WorkManagerGcmDispatcher {
    static final String TAG = Logger.tagWithPrefix((String)"WrkMgrGcmDispatcher");
    private static final long AWAIT_TIME_IN_MINUTES = 10L;
    private static final long AWAIT_TIME_IN_MILLISECONDS = 600000L;
    private final WorkTimer mWorkTimer;
    private final StartStopTokens mStartStopTokens = new StartStopTokens();
    WorkManagerImpl mWorkManagerImpl;

    public WorkManagerGcmDispatcher(@NonNull WorkManagerImpl workManager, @NonNull WorkTimer timer) {
        this.mWorkManagerImpl = workManager;
        this.mWorkTimer = timer;
    }

    @MainThread
    public void onInitializeTasks() {
        this.mWorkManagerImpl.getWorkTaskExecutor().executeOnTaskThread(new Runnable(){

            @Override
            public void run() {
                Logger.get().debug(TAG, "onInitializeTasks(): Rescheduling work");
                WorkManagerGcmDispatcher.this.mWorkManagerImpl.rescheduleEligibleWork();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onRunTask(@NonNull TaskParams taskParams) {
        WorkInfo.State state;
        Logger.get().debug(TAG, "Handling task " + taskParams);
        String workSpecId = taskParams.getTag();
        if (workSpecId == null || workSpecId.isEmpty()) {
            Logger.get().debug(TAG, "Bad request. No workSpecId.");
            return 2;
        }
        Bundle extras = taskParams.getExtras();
        int generation = extras != null ? extras.getInt("androidx.work.impl.background.gcm.GENERATION", 0) : 0;
        WorkGenerationalId id = new WorkGenerationalId(workSpecId, generation);
        WorkSpecExecutionListener listener = new WorkSpecExecutionListener(id, this.mStartStopTokens);
        StartStopToken startStopToken = this.mStartStopTokens.tokenFor(id);
        WorkSpecTimeLimitExceededListener timeLimitExceededListener = new WorkSpecTimeLimitExceededListener(this.mWorkManagerImpl, startStopToken);
        Processor processor = this.mWorkManagerImpl.getProcessor();
        processor.addExecutionListener((ExecutionListener)listener);
        String wakeLockTag = "WorkGcm-onRunTask (" + workSpecId + ")";
        PowerManager.WakeLock wakeLock = WakeLocks.newWakeLock((Context)this.mWorkManagerImpl.getApplicationContext(), (String)wakeLockTag);
        this.mWorkManagerImpl.startWork(startStopToken);
        this.mWorkTimer.startTimer(id, 600000L, (WorkTimer.TimeLimitExceededListener)timeLimitExceededListener);
        try {
            wakeLock.acquire();
            listener.getLatch().await(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException exception) {
            Logger.get().debug(TAG, "Rescheduling WorkSpec" + workSpecId);
            int n = this.reschedule(workSpecId);
            return n;
        }
        finally {
            processor.removeExecutionListener((ExecutionListener)listener);
            this.mWorkTimer.stopTimer(id);
            wakeLock.release();
        }
        if (listener.needsReschedule()) {
            Logger.get().debug(TAG, "Rescheduling WorkSpec" + workSpecId);
            return this.reschedule(workSpecId);
        }
        WorkDatabase workDatabase = this.mWorkManagerImpl.getWorkDatabase();
        WorkSpec workSpec = workDatabase.workSpecDao().getWorkSpec(workSpecId);
        WorkInfo.State state2 = state = workSpec != null ? workSpec.state : null;
        if (state == null) {
            Logger.get().debug(TAG, "WorkSpec %s does not exist" + workSpecId);
            return 2;
        }
        switch (state) {
            case SUCCEEDED: 
            case CANCELLED: {
                Logger.get().debug(TAG, "Returning RESULT_SUCCESS for WorkSpec " + workSpecId);
                return 0;
            }
            case FAILED: {
                Logger.get().debug(TAG, "Returning RESULT_FAILURE for WorkSpec " + workSpecId);
                return 2;
            }
        }
        Logger.get().debug(TAG, "Rescheduling eligible work.");
        return this.reschedule(workSpecId);
    }

    private int reschedule(final @NonNull String workSpecId) {
        final WorkDatabase workDatabase = this.mWorkManagerImpl.getWorkDatabase();
        workDatabase.runInTransaction(new Runnable(){

            @Override
            public void run() {
                workDatabase.workSpecDao().markWorkSpecScheduled(workSpecId, -1L);
                Schedulers.schedule((Configuration)WorkManagerGcmDispatcher.this.mWorkManagerImpl.getConfiguration(), (WorkDatabase)WorkManagerGcmDispatcher.this.mWorkManagerImpl.getWorkDatabase(), (List)WorkManagerGcmDispatcher.this.mWorkManagerImpl.getSchedulers());
            }
        });
        Logger.get().debug(TAG, "Returning RESULT_SUCCESS for WorkSpec " + workSpecId);
        return 0;
    }

    static class WorkSpecExecutionListener
    implements ExecutionListener {
        private static final String TAG = Logger.tagWithPrefix((String)"WorkSpecExecutionListener");
        private final WorkGenerationalId mGenerationalId;
        private final CountDownLatch mLatch;
        private boolean mNeedsReschedule;
        private final StartStopTokens mStartStopTokens;

        WorkSpecExecutionListener(@NonNull WorkGenerationalId generationalId, @NonNull StartStopTokens startStopTokens) {
            this.mGenerationalId = generationalId;
            this.mStartStopTokens = startStopTokens;
            this.mLatch = new CountDownLatch(1);
            this.mNeedsReschedule = false;
        }

        boolean needsReschedule() {
            return this.mNeedsReschedule;
        }

        CountDownLatch getLatch() {
            return this.mLatch;
        }

        public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
            if (!this.mGenerationalId.equals((Object)id)) {
                Logger.get().warning(TAG, "Notified for " + id + ", but was looking for " + this.mGenerationalId);
            } else {
                this.mStartStopTokens.remove(id);
                this.mNeedsReschedule = needsReschedule;
                this.mLatch.countDown();
            }
        }
    }

    static class WorkSpecTimeLimitExceededListener
    implements WorkTimer.TimeLimitExceededListener {
        private static final String TAG = Logger.tagWithPrefix((String)"WrkTimeLimitExceededLstnr");
        private final WorkManagerImpl mWorkManager;
        private final StartStopToken mStartStopToken;

        WorkSpecTimeLimitExceededListener(@NonNull WorkManagerImpl workManager, @NonNull StartStopToken startStopToken) {
            this.mWorkManager = workManager;
            this.mStartStopToken = startStopToken;
        }

        public void onTimeLimitExceeded(@NonNull WorkGenerationalId id) {
            Logger.get().debug(TAG, "WorkSpec time limit exceeded " + id);
            this.mWorkManager.stopWork(this.mStartStopToken);
        }
    }
}

