/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableWorkerImplClient;
import androidx.work.multiprocess.RemoteClientUtils;
import androidx.work.multiprocess.RemoteDispatcher;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableInterruptRequest;
import androidx.work.multiprocess.parcelable.ParcelableRemoteWorkRequest;
import androidx.work.multiprocess.parcelable.ParcelableResult;
import com.google.common.util.concurrent.ListenableFuture;

public abstract class RemoteListenableWorker
extends ListenableWorker {
    static final String TAG = Logger.tagWithPrefix((String)"RemoteListenableWorker");
    public static final String ARGUMENT_PACKAGE_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_PACKAGE_NAME";
    public static final String ARGUMENT_CLASS_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_CLASS_NAME";
    final WorkerParameters mWorkerParameters;
    final ListenableWorkerImplClient mClient;
    @Nullable
    String mWorkerClassName;
    @Nullable
    private ComponentName mComponentName;

    public RemoteListenableWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
        this.mWorkerParameters = workerParams;
        this.mClient = new ListenableWorkerImplClient(appContext, this.getBackgroundExecutor());
    }

    @NonNull
    public final ListenableFuture<ListenableWorker.Result> startWork() {
        SettableFuture future = SettableFuture.create();
        Data data = this.getInputData();
        final String id = this.mWorkerParameters.getId().toString();
        String packageName = data.getString(ARGUMENT_PACKAGE_NAME);
        String serviceClassName = data.getString(ARGUMENT_CLASS_NAME);
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            String message = "Need to specify a package name for the Remote Service.";
            Logger.get().error(TAG, message);
            future.setException((Throwable)new IllegalArgumentException(message));
            return future;
        }
        if (TextUtils.isEmpty((CharSequence)serviceClassName)) {
            String message = "Need to specify a class name for the Remote Service.";
            Logger.get().error(TAG, message);
            future.setException((Throwable)new IllegalArgumentException(message));
            return future;
        }
        this.mComponentName = new ComponentName(packageName, serviceClassName);
        final WorkManagerImpl workManager = WorkManagerImpl.getInstance((Context)this.getApplicationContext());
        ListenableFuture<byte[]> result = this.mClient.execute(this.mComponentName, new RemoteDispatcher<IListenableWorkerImpl>(){

            @Override
            public void execute(@NonNull IListenableWorkerImpl listenableWorkerImpl, @NonNull IWorkManagerImplCallback callback) throws RemoteException {
                WorkSpec workSpec = workManager.getWorkDatabase().workSpecDao().getWorkSpec(id);
                RemoteListenableWorker.this.mWorkerClassName = workSpec.workerClassName;
                ParcelableRemoteWorkRequest remoteWorkRequest = new ParcelableRemoteWorkRequest(workSpec.workerClassName, RemoteListenableWorker.this.mWorkerParameters);
                byte[] request = ParcelConverters.marshall(remoteWorkRequest);
                listenableWorkerImpl.startWork(request, callback);
            }
        });
        return RemoteClientUtils.map(result, new Function<byte[], ListenableWorker.Result>(){

            public ListenableWorker.Result apply(byte[] input) {
                ParcelableResult parcelableResult = ParcelConverters.unmarshall(input, ParcelableResult.CREATOR);
                Logger.get().debug(TAG, "Cleaning up");
                RemoteListenableWorker.this.mClient.unbindService();
                return parcelableResult.getResult();
            }
        }, this.getBackgroundExecutor());
    }

    @NonNull
    public abstract ListenableFuture<ListenableWorker.Result> startRemoteWork();

    @SuppressLint(value={"NewApi"})
    @CallSuper
    public void onStopped() {
        super.onStopped();
        int stopReason = this.getStopReason();
        if (this.mComponentName != null) {
            this.mClient.execute(this.mComponentName, (listenableWorkerImpl, callback) -> {
                ParcelableInterruptRequest interruptRequest = new ParcelableInterruptRequest(this.mWorkerParameters.getId().toString(), stopReason);
                byte[] request = ParcelConverters.marshall(interruptRequest);
                listenableWorkerImpl.interrupt(request, callback);
            });
        }
    }
}

