/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import com.google.common.util.concurrent.ListenableFuture;

public abstract class RemoteListenableWorker
extends ListenableWorker {
    static final String TAG = Logger.tagWithPrefix((String)"RemoteListenableWorker");
    public static final String ARGUMENT_PACKAGE_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_PACKAGE_NAME";
    public static final String ARGUMENT_CLASS_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_CLASS_NAME";

    public RemoteListenableWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
    }

    @NonNull
    public final ListenableFuture<ListenableWorker.Result> startWork() {
        String message = "startWork() shouldn't never be called on RemoteListenableWorker";
        return RemoteListenableWorker.getFailedFuture(message);
    }

    @NonNull
    public abstract ListenableFuture<ListenableWorker.Result> startRemoteWork();

    private static ListenableFuture<ListenableWorker.Result> getFailedFuture(@NonNull String message) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            Logger.get().error(TAG, message);
            completer.setException((Throwable)new IllegalArgumentException(message));
            return "RemoteListenableWorker Failed Future";
        });
    }
}

