/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.work.Data;
import androidx.work.DirectExecutor;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.RunnableScheduler;
import androidx.work.WorkContinuation;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.multiprocess.IWorkManagerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.RemoteClientUtilsKt;
import androidx.work.multiprocess.RemoteDispatcher;
import androidx.work.multiprocess.RemoteExecuteKt;
import androidx.work.multiprocess.RemoteWorkContinuation;
import androidx.work.multiprocess.RemoteWorkContinuationImpl;
import androidx.work.multiprocess.RemoteWorkManager;
import androidx.work.multiprocess.RemoteWorkManagerService;
import androidx.work.multiprocess.ServiceBindingKt;
import androidx.work.multiprocess.Session;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableForegroundRequestInfo;
import androidx.work.multiprocess.parcelable.ParcelableUpdateRequest;
import androidx.work.multiprocess.parcelable.ParcelableWorkContinuationImpl;
import androidx.work.multiprocess.parcelable.ParcelableWorkInfos;
import androidx.work.multiprocess.parcelable.ParcelableWorkQuery;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequest;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequests;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

@SuppressLint(value={"BanKeepAnnotation"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteWorkManagerClient
extends RemoteWorkManager {
    private static final long SESSION_TIMEOUT_MILLIS = 6000000L;
    static final String TAG = Logger.tagWithPrefix((String)"RemoteWorkManagerClient");
    public static final Function<byte[], Void> sVoidMapper = input -> null;
    Session<IWorkManagerImpl> mSession;
    final Context mContext;
    final WorkManagerImpl mWorkManager;
    final Executor mExecutor;
    final Object mLock;
    private volatile long mSessionIndex;
    private final long mSessionTimeout;
    private final RunnableScheduler mRunnableScheduler;
    private final SessionTracker mSessionTracker;

    public RemoteWorkManagerClient(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this(context, workManager, 6000000L);
    }

    public RemoteWorkManagerClient(@NonNull Context context, @NonNull WorkManagerImpl workManager, long sessionTimeout) {
        this.mContext = context.getApplicationContext();
        this.mWorkManager = workManager;
        this.mExecutor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
        this.mLock = new Object();
        this.mSession = null;
        this.mSessionTracker = new SessionTracker(this);
        this.mSessionTimeout = sessionTimeout;
        this.mRunnableScheduler = this.mWorkManager.getConfiguration().getRunnableScheduler();
    }

    @NonNull
    public ListenableFuture<Void> enqueue(@NonNull WorkRequest request) {
        return this.enqueue(Collections.singletonList(request));
    }

    @NonNull
    public ListenableFuture<Void> enqueue(final @NonNull List<WorkRequest> requests) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws RemoteException {
                byte[] request = ParcelConverters.marshall(new ParcelableWorkRequests(requests));
                iWorkManagerImpl.enqueueWorkRequests(request, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> enqueueUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull List<OneTimeWorkRequest> work) {
        return this.beginUniqueWork(uniqueWorkName, existingWorkPolicy, work).enqueue();
    }

    @NonNull
    public ListenableFuture<Void> enqueueUniquePeriodicWork(@NonNull String uniqueWorkName, @NonNull ExistingPeriodicWorkPolicy existingPeriodicWorkPolicy, @NonNull PeriodicWorkRequest periodicWork) {
        if (existingPeriodicWorkPolicy == ExistingPeriodicWorkPolicy.UPDATE) {
            ListenableFuture<byte[]> result = this.execute((iWorkManagerImpl, callback) -> {
                byte[] request = ParcelConverters.marshall(new ParcelableWorkRequest((WorkRequest)periodicWork));
                iWorkManagerImpl.updateUniquePeriodicWorkRequest(uniqueWorkName, request, callback);
            });
            return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
        }
        WorkContinuationImpl continuation = this.mWorkManager.createWorkContinuationForUniquePeriodicWork(uniqueWorkName, existingPeriodicWorkPolicy, periodicWork);
        return this.enqueue((WorkContinuation)continuation);
    }

    @NonNull
    public RemoteWorkContinuation beginWith(@NonNull List<OneTimeWorkRequest> work) {
        return new RemoteWorkContinuationImpl(this, this.mWorkManager.beginWith(work));
    }

    @NonNull
    public RemoteWorkContinuation beginUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull List<OneTimeWorkRequest> work) {
        return new RemoteWorkContinuationImpl(this, this.mWorkManager.beginUniqueWork(uniqueWorkName, existingWorkPolicy, work));
    }

    @NonNull
    public ListenableFuture<Void> enqueue(final @NonNull WorkContinuation continuation) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                WorkContinuationImpl workContinuation = (WorkContinuationImpl)continuation;
                byte[] request = ParcelConverters.marshall(new ParcelableWorkContinuationImpl(workContinuation));
                iWorkManagerImpl.enqueueContinuation(request, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelWorkById(final @NonNull UUID id) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelWorkById(id.toString(), callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelAllWorkByTag(final @NonNull String tag) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelAllWorkByTag(tag, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelUniqueWork(final @NonNull String uniqueWorkName) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelUniqueWork(uniqueWorkName, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelAllWork() {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelAllWork(callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<List<WorkInfo>> getWorkInfos(final @NonNull WorkQuery workQuery) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                byte[] request = ParcelConverters.marshall(new ParcelableWorkQuery(workQuery));
                iWorkManagerImpl.queryWorkInfo(request, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, new Function<byte[], List<WorkInfo>>(){

            public List<WorkInfo> apply(byte[] input) {
                ParcelableWorkInfos infos = ParcelConverters.unmarshall(input, ParcelableWorkInfos.CREATOR);
                return infos.getWorkInfos();
            }
        }, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> setProgress(final @NonNull UUID id, final @NonNull Data data) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                byte[] request = ParcelConverters.marshall(new ParcelableUpdateRequest(id, data));
                iWorkManagerImpl.setProgress(request, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> setForegroundAsync(final @NonNull String id, final @NonNull ForegroundInfo foregroundInfo) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                byte[] request = ParcelConverters.marshall(new ParcelableForegroundRequestInfo(id, foregroundInfo));
                iWorkManagerImpl.setForegroundAsync(request, callback);
            }
        });
        return RemoteClientUtilsKt.map(result, sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<byte[]> execute(@NonNull RemoteDispatcher<IWorkManagerImpl> dispatcher) {
        return this.execute(this.getSession(), dispatcher);
    }

    @NonNull
    public ListenableFuture<IWorkManagerImpl> getSession() {
        return this.getSession(RemoteWorkManagerClient.newIntent(this.mContext));
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    public long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    @Nullable
    Session<IWorkManagerImpl> getCurrentSession() {
        return this.mSession;
    }

    @NonNull
    public SessionTracker getSessionTracker() {
        return this.mSessionTracker;
    }

    @NonNull
    public Object getSessionLock() {
        return this.mLock;
    }

    @NonNull
    public Executor getExecutor() {
        return this.mExecutor;
    }

    public long getSessionIndex() {
        return this.mSessionIndex;
    }

    @NonNull
    @VisibleForTesting
    ListenableFuture<byte[]> execute(@NonNull ListenableFuture<IWorkManagerImpl> session, @NonNull RemoteDispatcher<IWorkManagerImpl> dispatcher) {
        ListenableFuture<byte[]> future2 = RemoteExecuteKt.execute(this.mExecutor, session, dispatcher);
        future2.addListener(() -> {
            SessionTracker tracker = this.getSessionTracker();
            this.mRunnableScheduler.scheduleWithDelay(this.getSessionTimeout(), (Runnable)tracker);
        }, this.mExecutor);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    ListenableFuture<IWorkManagerImpl> getSession(@NonNull Intent intent) {
        Object object = this.mLock;
        synchronized (object) {
            ListenableFuture<IWorkManagerImpl> resultFuture;
            ++this.mSessionIndex;
            if (this.mSession == null) {
                this.mSession = ServiceBindingKt.bindToService(this.mContext, intent, IWorkManagerImpl.Stub::asInterface, TAG);
                resultFuture = this.mSession.getConnectedFuture();
                this.mSession.getDisconnectedFuture().addListener(this::cleanUp, (Executor)DirectExecutor.INSTANCE);
            } else {
                resultFuture = this.mSession.getConnectedFuture();
            }
            this.mRunnableScheduler.cancel((Runnable)this.mSessionTracker);
            return resultFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Cleaning up.");
            this.mSession = null;
        }
    }

    private static Intent newIntent(@NonNull Context context) {
        return new Intent(context, RemoteWorkManagerService.class);
    }

    public static class SessionTracker
    implements Runnable {
        private static final String TAG = Logger.tagWithPrefix((String)"SessionHandler");
        private final RemoteWorkManagerClient mClient;

        public SessionTracker(@NonNull RemoteWorkManagerClient client) {
            this.mClient = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long preLockIndex = this.mClient.getSessionIndex();
            Object object = this.mClient.getSessionLock();
            synchronized (object) {
                long sessionIndex = this.mClient.getSessionIndex();
                Session<IWorkManagerImpl> currentSession = this.mClient.getCurrentSession();
                if (currentSession != null) {
                    if (preLockIndex == sessionIndex) {
                        Logger.get().debug(TAG, "Unbinding service");
                        this.mClient.getContext().unbindService(currentSession);
                        currentSession.onBindingDied();
                    } else {
                        Logger.get().debug(TAG, "Ignoring request to unbind.");
                    }
                }
            }
        }
    }
}

