/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import androidx.core.util.Function;
import androidx.work.Logger;
import androidx.work.multiprocess.Session;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002*\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"bindToService", "Landroidx/work/multiprocess/Session;", "T", "Landroid/os/IInterface;", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "asInterface", "Landroidx/core/util/Function;", "Landroid/os/IBinder;", "loggingTag", "", "work-multiprocess_release"})
public final class ServiceBindingKt {
    @NotNull
    public static final <T extends IInterface> Session<T> bindToService(@NotNull Context context, @NotNull Intent intent, @NotNull Function<IBinder, T> asInterface, @NotNull String loggingTag) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(asInterface, (String)"asInterface");
        Intrinsics.checkNotNullParameter((Object)loggingTag, (String)"loggingTag");
        Logger.get().debug(loggingTag, "Binding via " + intent);
        Session<T> session = new Session<T>(loggingTag, asInterface);
        try {
            boolean bound = context.bindService(intent, (ServiceConnection)session, 1);
            if (!bound) {
                session.resolveClosedConnection(new RuntimeException("Unable to bind to service"));
            }
        }
        catch (Throwable throwable) {
            session.resolveClosedConnection(throwable);
        }
        return session;
    }
}

