/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.impl.model.WorkTypeConverters;
import androidx.work.impl.utils.NetworkRequest28;
import androidx.work.impl.utils.NetworkRequestCompatKt;
import androidx.work.multiprocess.parcelable.ParcelUtils;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableConstraints
implements Parcelable {
    private final Constraints mConstraints;
    public static final Parcelable.Creator<ParcelableConstraints> CREATOR = new Parcelable.Creator<ParcelableConstraints>(){

        public ParcelableConstraints createFromParcel(Parcel in) {
            return new ParcelableConstraints(in);
        }

        public ParcelableConstraints[] newArray(int size) {
            return new ParcelableConstraints[size];
        }
    };

    public ParcelableConstraints(@NonNull Constraints constraints) {
        this.mConstraints = constraints;
    }

    public ParcelableConstraints(@NonNull Parcel in) {
        boolean hasNetworkRequest;
        Constraints.Builder builder = new Constraints.Builder();
        NetworkType networkType = WorkTypeConverters.intToNetworkType((int)in.readInt());
        builder.setRequiredNetworkType(networkType);
        boolean batteryNotLow = ParcelUtils.readBooleanValue(in);
        builder.setRequiresBatteryNotLow(batteryNotLow);
        boolean requiresCharging = ParcelUtils.readBooleanValue(in);
        builder.setRequiresCharging(requiresCharging);
        boolean requiresStorageNotLow = ParcelUtils.readBooleanValue(in);
        builder.setRequiresStorageNotLow(requiresStorageNotLow);
        if (Build.VERSION.SDK_INT >= 23) {
            boolean requiresDeviceIdle = ParcelUtils.readBooleanValue(in);
            builder.setRequiresDeviceIdle(requiresDeviceIdle);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            boolean hasTriggers = ParcelUtils.readBooleanValue(in);
            if (hasTriggers) {
                Set contentUriTriggers = WorkTypeConverters.byteArrayToSetOfTriggers((byte[])in.createByteArray());
                for (Constraints.ContentUriTrigger trigger : contentUriTriggers) {
                    builder.addContentUriTrigger(trigger.getUri(), trigger.isTriggeredForDescendants());
                }
            }
            long triggerMaxContentDelay = in.readLong();
            builder.setTriggerContentMaxDelay(triggerMaxContentDelay, TimeUnit.MILLISECONDS);
            long triggerContentUpdateDelay = in.readLong();
            builder.setTriggerContentUpdateDelay(triggerContentUpdateDelay, TimeUnit.MILLISECONDS);
        }
        if (Build.VERSION.SDK_INT >= 28 && (hasNetworkRequest = ParcelUtils.readBooleanValue(in))) {
            NetworkRequest request = NetworkRequest28.createNetworkRequest((int[])in.createIntArray(), (int[])in.createIntArray());
            builder.setRequiredNetworkRequest(request, NetworkType.NOT_REQUIRED);
        }
        this.mConstraints = builder.build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(WorkTypeConverters.networkTypeToInt((NetworkType)this.mConstraints.getRequiredNetworkType()));
        ParcelUtils.writeBooleanValue(parcel, this.mConstraints.requiresBatteryNotLow());
        ParcelUtils.writeBooleanValue(parcel, this.mConstraints.requiresCharging());
        ParcelUtils.writeBooleanValue(parcel, this.mConstraints.requiresStorageNotLow());
        if (Build.VERSION.SDK_INT >= 23) {
            ParcelUtils.writeBooleanValue(parcel, this.mConstraints.requiresDeviceIdle());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            boolean hasTriggers = this.mConstraints.hasContentUriTriggers();
            ParcelUtils.writeBooleanValue(parcel, hasTriggers);
            if (hasTriggers) {
                byte[] serializedTriggers = WorkTypeConverters.setOfTriggersToByteArray((Set)this.mConstraints.getContentUriTriggers());
                parcel.writeByteArray(serializedTriggers);
            }
            parcel.writeLong(this.mConstraints.getContentTriggerMaxDelayMillis());
            parcel.writeLong(this.mConstraints.getContentTriggerUpdateDelayMillis());
        }
        if (Build.VERSION.SDK_INT >= 28) {
            NetworkRequest networkRequest = this.mConstraints.getRequiredNetworkRequest();
            boolean hasNetworkRequest = networkRequest != null;
            ParcelUtils.writeBooleanValue(parcel, hasNetworkRequest);
            if (hasNetworkRequest) {
                parcel.writeIntArray(NetworkRequestCompatKt.getCapabilitiesCompat((NetworkRequest)networkRequest));
                parcel.writeIntArray(NetworkRequestCompatKt.getTransportTypesCompat((NetworkRequest)networkRequest));
            }
        }
    }

    @NonNull
    public Constraints getConstraints() {
        return this.mConstraints;
    }
}

