/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableWorkQuery
implements Parcelable {
    private final WorkQuery mWorkQuery;
    public static final Parcelable.Creator<ParcelableWorkQuery> CREATOR = new Parcelable.Creator<ParcelableWorkQuery>(){

        public ParcelableWorkQuery createFromParcel(Parcel in) {
            return new ParcelableWorkQuery(in);
        }

        public ParcelableWorkQuery[] newArray(int size) {
            return new ParcelableWorkQuery[size];
        }
    };

    public ParcelableWorkQuery(@NonNull WorkQuery workQuery) {
        this.mWorkQuery = workQuery;
    }

    protected ParcelableWorkQuery(@NonNull Parcel parcel) {
        List ids = Collections.emptyList();
        int length = parcel.readInt();
        if (length > 0) {
            ids = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                ids.add(UUID.fromString(parcel.readString()));
            }
        }
        ArrayList uniqueWorkNames = parcel.createStringArrayList();
        ArrayList tags = parcel.createStringArrayList();
        List states = Collections.emptyList();
        length = parcel.readInt();
        if (length > 0) {
            states = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                states.add(WorkTypeConverters.intToState((int)parcel.readInt()));
            }
        }
        this.mWorkQuery = WorkQuery.Builder.fromIds(ids).addUniqueWorkNames((List)uniqueWorkNames).addTags((List)tags).addStates(states).build();
    }

    @NonNull
    public WorkQuery getWorkQuery() {
        return this.mWorkQuery;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        List ids = this.mWorkQuery.getIds();
        parcel.writeInt(ids.size());
        if (!ids.isEmpty()) {
            for (UUID id : ids) {
                parcel.writeString(id.toString());
            }
        }
        List uniqueNames = this.mWorkQuery.getUniqueWorkNames();
        parcel.writeStringList(uniqueNames);
        List tags = this.mWorkQuery.getTags();
        parcel.writeStringList(tags);
        List states = this.mWorkQuery.getStates();
        parcel.writeInt(states.size());
        if (!states.isEmpty()) {
            for (WorkInfo.State state2 : states) {
                parcel.writeInt(WorkTypeConverters.stateToInt((WorkInfo.State)state2));
            }
        }
    }
}

