/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkContinuation;
import androidx.work.multiprocess.RemoteWorkContinuation;
import androidx.work.multiprocess.RemoteWorkManagerClient;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;

public class RemoteWorkContinuationImpl
extends RemoteWorkContinuation {
    private final RemoteWorkManagerClient mClient;
    private final WorkContinuation mContinuation;

    public RemoteWorkContinuationImpl(@NonNull RemoteWorkManagerClient client, @NonNull WorkContinuation continuation) {
        this.mClient = client;
        this.mContinuation = continuation;
    }

    @NonNull
    @SuppressLint(value={"EnqueueWork"})
    public RemoteWorkContinuation then(@NonNull List<OneTimeWorkRequest> work) {
        return new RemoteWorkContinuationImpl(this.mClient, this.mContinuation.then(work));
    }

    @NonNull
    public ListenableFuture<Void> enqueue() {
        return this.mClient.enqueue(this.mContinuation);
    }

    @NonNull
    @SuppressLint(value={"EnqueueWork"})
    protected RemoteWorkContinuation combineInternal(@NonNull List<RemoteWorkContinuation> continuations) {
        int size = continuations.size();
        ArrayList<WorkContinuation> workContinuations = new ArrayList<WorkContinuation>(size);
        for (RemoteWorkContinuation continuation : continuations) {
            workContinuations.add(((RemoteWorkContinuationImpl)continuation).mContinuation);
        }
        WorkContinuation result = WorkContinuation.combine(workContinuations);
        return new RemoteWorkContinuationImpl(this.mClient, result);
    }
}

