/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Operation;
import androidx.work.WorkInfo;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.utils.SerialExecutor;
import androidx.work.multiprocess.IWorkManagerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableWorkContinuationImpl;
import androidx.work.multiprocess.parcelable.ParcelableWorkInfos;
import androidx.work.multiprocess.parcelable.ParcelableWorkQuery;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequests;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteWorkManagerImpl
extends IWorkManagerImpl.Stub {
    static byte[] sEMPTY = new byte[0];
    private final WorkManagerImpl mWorkManager;

    RemoteWorkManagerImpl(@NonNull Context context) {
        this.mWorkManager = WorkManagerImpl.getInstance((Context)context);
    }

    @MainThread
    public void enqueueWorkRequests(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkRequests parcelledRequests = ParcelConverters.unmarshall(request, ParcelableWorkRequests.CREATOR);
            List<WorkRequest> workRequests = parcelledRequests.getRequests();
            Operation operation = this.mWorkManager.enqueue(workRequests);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void enqueueContinuation(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkContinuationImpl parcelledRequest = ParcelConverters.unmarshall(request, ParcelableWorkContinuationImpl.CREATOR);
            WorkContinuationImpl continuation = parcelledRequest.toWorkContinuationImpl(this.mWorkManager);
            Operation operation = continuation.enqueue();
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void cancelWorkById(@NonNull String id, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelWorkById(UUID.fromString(id));
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void cancelAllWorkByTag(@NonNull String tag, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelAllWorkByTag(tag);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void cancelUniqueWork(@NonNull String name, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelUniqueWork(name);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void cancelAllWork(@NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelAllWork();
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }

    public void queryWorkInfo(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkQuery parcelled = ParcelConverters.unmarshall(request, ParcelableWorkQuery.CREATOR);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
            ListenableFuture future = this.mWorkManager.getWorkInfos(parcelled.getWorkQuery());
            ListenableCallback<List<WorkInfo>> listenableCallback = new ListenableCallback<List<WorkInfo>>((Executor)executor, callback, future){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull List<WorkInfo> result) {
                    ParcelableWorkInfos parcelables = new ParcelableWorkInfos(result);
                    return ParcelConverters.marshall(parcelables);
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.failureCallback(callback, throwable);
        }
    }
}

