/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.Logger;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkContinuation;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.IWorkManagerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.RemoteCallback;
import androidx.work.multiprocess.RemoteClientUtils;
import androidx.work.multiprocess.RemoteDispatcher;
import androidx.work.multiprocess.RemoteWorkContinuation;
import androidx.work.multiprocess.RemoteWorkContinuationImpl;
import androidx.work.multiprocess.RemoteWorkManager;
import androidx.work.multiprocess.RemoteWorkManagerService;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableUpdateRequest;
import androidx.work.multiprocess.parcelable.ParcelableWorkContinuationImpl;
import androidx.work.multiprocess.parcelable.ParcelableWorkInfos;
import androidx.work.multiprocess.parcelable.ParcelableWorkQuery;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequests;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteWorkManagerClient
extends RemoteWorkManager {
    static final String TAG = Logger.tagWithPrefix((String)"RemoteWorkManagerClient");
    final Context mContext;
    final WorkManagerImpl mWorkManager;
    final Executor mExecutor;
    final Object mLock;
    private Session mSession;

    @SuppressLint(value={"BanKeepAnnotation"})
    @Keep
    public RemoteWorkManagerClient(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this.mContext = context.getApplicationContext();
        this.mWorkManager = workManager;
        this.mExecutor = this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor();
        this.mLock = new Object();
        this.mSession = null;
    }

    @NonNull
    public ListenableFuture<Void> enqueue(@NonNull WorkRequest request) {
        return this.enqueue(Collections.singletonList(request));
    }

    @NonNull
    public ListenableFuture<Void> enqueue(final @NonNull List<WorkRequest> requests) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws RemoteException {
                byte[] request = ParcelConverters.marshall(new ParcelableWorkRequests(requests));
                iWorkManagerImpl.enqueueWorkRequests(request, callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> enqueueUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull List<OneTimeWorkRequest> work) {
        return this.beginUniqueWork(uniqueWorkName, existingWorkPolicy, work).enqueue();
    }

    @NonNull
    public ListenableFuture<Void> enqueueUniquePeriodicWork(@NonNull String uniqueWorkName, @NonNull ExistingPeriodicWorkPolicy existingPeriodicWorkPolicy, @NonNull PeriodicWorkRequest periodicWork) {
        WorkContinuationImpl continuation = this.mWorkManager.createWorkContinuationForUniquePeriodicWork(uniqueWorkName, existingPeriodicWorkPolicy, periodicWork);
        return this.enqueue((WorkContinuation)continuation);
    }

    @NonNull
    public RemoteWorkContinuation beginWith(@NonNull List<OneTimeWorkRequest> work) {
        return new RemoteWorkContinuationImpl(this, this.mWorkManager.beginWith(work));
    }

    @NonNull
    public RemoteWorkContinuation beginUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull List<OneTimeWorkRequest> work) {
        return new RemoteWorkContinuationImpl(this, this.mWorkManager.beginUniqueWork(uniqueWorkName, existingWorkPolicy, work));
    }

    @NonNull
    public ListenableFuture<Void> enqueue(final @NonNull WorkContinuation continuation) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                WorkContinuationImpl workContinuation = (WorkContinuationImpl)continuation;
                byte[] request = ParcelConverters.marshall(new ParcelableWorkContinuationImpl(workContinuation));
                iWorkManagerImpl.enqueueContinuation(request, callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelWorkById(final @NonNull UUID id) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelWorkById(id.toString(), callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelAllWorkByTag(final @NonNull String tag) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelAllWorkByTag(tag, callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelUniqueWork(final @NonNull String uniqueWorkName) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelUniqueWork(uniqueWorkName, callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> cancelAllWork() {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                iWorkManagerImpl.cancelAllWork(callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<List<WorkInfo>> getWorkInfos(final @NonNull WorkQuery workQuery) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                byte[] request = ParcelConverters.marshall(new ParcelableWorkQuery(workQuery));
                iWorkManagerImpl.queryWorkInfo(request, callback);
            }
        });
        return RemoteClientUtils.map(result, new Function<byte[], List<WorkInfo>>(){

            public List<WorkInfo> apply(byte[] input) {
                ParcelableWorkInfos infos = ParcelConverters.unmarshall(input, ParcelableWorkInfos.CREATOR);
                return infos.getWorkInfos();
            }
        }, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<Void> setProgress(final @NonNull UUID id, final @NonNull Data data) {
        ListenableFuture<byte[]> result = this.execute(new RemoteDispatcher<IWorkManagerImpl>(){

            @Override
            public void execute(@NonNull IWorkManagerImpl iWorkManagerImpl, @NonNull IWorkManagerImplCallback callback) throws Throwable {
                byte[] request = ParcelConverters.marshall(new ParcelableUpdateRequest(id, data));
                iWorkManagerImpl.setProgress(request, callback);
            }
        });
        return RemoteClientUtils.map(result, RemoteClientUtils.sVoidMapper, this.mExecutor);
    }

    @NonNull
    public ListenableFuture<byte[]> execute(@NonNull RemoteDispatcher<IWorkManagerImpl> dispatcher) {
        return this.execute(this.getSession(), dispatcher, new RemoteCallback());
    }

    @NonNull
    public ListenableFuture<IWorkManagerImpl> getSession() {
        return this.getSession(RemoteWorkManagerClient.newIntent(this.mContext));
    }

    @NonNull
    @VisibleForTesting
    ListenableFuture<byte[]> execute(final @NonNull ListenableFuture<IWorkManagerImpl> session, final @NonNull RemoteDispatcher<IWorkManagerImpl> dispatcher, final @NonNull RemoteCallback callback) {
        session.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final IWorkManagerImpl iWorkManager = (IWorkManagerImpl)session.get();
                    callback.setBinder(iWorkManager.asBinder());
                    RemoteWorkManagerClient.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                dispatcher.execute(iWorkManager, (IWorkManagerImplCallback)callback);
                            }
                            catch (Throwable innerThrowable) {
                                Logger.get().error(TAG, "Unable to execute", new Throwable[]{innerThrowable});
                                ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, innerThrowable);
                            }
                        }
                    });
                }
                catch (InterruptedException | ExecutionException exception) {
                    Logger.get().error(TAG, "Unable to bind to service", new Throwable[0]);
                    ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, new RuntimeException("Unable to bind to service"));
                    RemoteWorkManagerClient.this.cleanUp();
                }
            }
        }, this.mExecutor);
        return callback.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    ListenableFuture<IWorkManagerImpl> getSession(@NonNull Intent intent) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSession == null) {
                Logger.get().debug(TAG, "Creating a new session", new Throwable[0]);
                this.mSession = new Session(this);
                try {
                    boolean bound = this.mContext.bindService(intent, (ServiceConnection)this.mSession, 1);
                    if (!bound) {
                        this.unableToBind(this.mSession, new RuntimeException("Unable to bind to service"));
                    }
                }
                catch (Throwable throwable) {
                    this.unableToBind(this.mSession, throwable);
                }
            }
            return this.mSession.mFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Cleaning up.", new Throwable[0]);
            this.mSession = null;
        }
    }

    private void unableToBind(@NonNull Session session, @NonNull Throwable throwable) {
        Logger.get().error(TAG, "Unable to bind to service", new Throwable[]{throwable});
        session.mFuture.setException(throwable);
    }

    private static Intent newIntent(@NonNull Context context) {
        return new Intent(context, RemoteWorkManagerService.class);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Session
    implements ServiceConnection {
        private static final String TAG = Logger.tagWithPrefix((String)"RemoteWMgr.Connection");
        final SettableFuture<IWorkManagerImpl> mFuture;
        final RemoteWorkManagerClient mClient;

        public Session(@NonNull RemoteWorkManagerClient client) {
            this.mClient = client;
            this.mFuture = SettableFuture.create();
        }

        public void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
            Logger.get().debug(TAG, "Service connected", new Throwable[0]);
            IWorkManagerImpl iWorkManagerImpl = IWorkManagerImpl.Stub.asInterface((IBinder)iBinder);
            this.mFuture.set((Object)iWorkManagerImpl);
        }

        public void onServiceDisconnected(@NonNull ComponentName componentName) {
            Logger.get().debug(TAG, "Service disconnected", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException("Service disconnected"));
            this.mClient.cleanUp();
        }

        public void onBindingDied(@NonNull ComponentName name) {
            Logger.get().debug(TAG, "Binding died", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException("Binding died"));
            this.mClient.cleanUp();
        }

        public void onNullBinding(@NonNull ComponentName name) {
            Logger.get().error(TAG, "Unable to bind to service", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException(String.format("Cannot bind to service %s", name)));
        }
    }
}

