/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.multiprocess.parcelable.ParcelableData;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableResult
implements Parcelable {
    private final ListenableWorker.Result mResult;
    public static final Parcelable.Creator<ParcelableResult> CREATOR = new Parcelable.Creator<ParcelableResult>(){

        @NonNull
        public ParcelableResult createFromParcel(Parcel in) {
            return new ParcelableResult(in);
        }

        public ParcelableResult[] newArray(int size) {
            return new ParcelableResult[size];
        }
    };

    public ParcelableResult(@NonNull ListenableWorker.Result result) {
        this.mResult = result;
    }

    public ParcelableResult(@NonNull Parcel in) {
        int resultType = in.readInt();
        ParcelableData parcelableOutputData = new ParcelableData(in);
        this.mResult = ParcelableResult.intToResultType(resultType, parcelableOutputData.getData());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        int resultType = ParcelableResult.resultTypeOf(this.mResult);
        parcel.writeInt(resultType);
        Data outputData = this.mResult.getOutputData();
        ParcelableData parcelableOutputData = new ParcelableData(outputData);
        parcelableOutputData.writeToParcel(parcel, flags);
    }

    @NonNull
    public ListenableWorker.Result getResult() {
        return this.mResult;
    }

    private static int resultTypeOf(ListenableWorker.Result result) {
        if (result instanceof ListenableWorker.Result.Retry) {
            return 1;
        }
        if (result instanceof ListenableWorker.Result.Success) {
            return 2;
        }
        if (result instanceof ListenableWorker.Result.Failure) {
            return 3;
        }
        throw new IllegalStateException(String.format("Unknown Result %s", result));
    }

    @NonNull
    private static ListenableWorker.Result intToResultType(int resultType, @NonNull Data data) {
        ListenableWorker.Result result = null;
        if (resultType == 1) {
            result = ListenableWorker.Result.retry();
        } else if (resultType == 2) {
            result = ListenableWorker.Result.success((Data)data);
        } else if (resultType == 3) {
            result = ListenableWorker.Result.failure((Data)data);
        } else {
            throw new IllegalStateException(String.format("Unknown result type %s", resultType));
        }
        return result;
    }
}

