/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.Data;
import androidx.work.ForegroundUpdater;
import androidx.work.ProgressUpdater;
import androidx.work.WorkerParameters;
import androidx.work.impl.Processor;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.utils.WorkForegroundUpdater;
import androidx.work.impl.utils.WorkProgressUpdater;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.multiprocess.parcelable.ParcelableData;
import androidx.work.multiprocess.parcelable.ParcelableRuntimeExtras;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableWorkerParameters
implements Parcelable {
    @NonNull
    private final UUID mId;
    @NonNull
    private final Data mData;
    @NonNull
    private final Set<String> mTags;
    @NonNull
    private final WorkerParameters.RuntimeExtras mRuntimeExtras;
    private final int mRunAttemptCount;
    public static final Parcelable.Creator<ParcelableWorkerParameters> CREATOR = new Parcelable.Creator<ParcelableWorkerParameters>(){

        @NonNull
        public ParcelableWorkerParameters createFromParcel(Parcel in) {
            return new ParcelableWorkerParameters(in);
        }

        public ParcelableWorkerParameters[] newArray(int size) {
            return new ParcelableWorkerParameters[size];
        }
    };

    public ParcelableWorkerParameters(@NonNull WorkerParameters parameters) {
        this.mId = parameters.getId();
        this.mData = parameters.getInputData();
        this.mTags = parameters.getTags();
        this.mRuntimeExtras = parameters.getRuntimeExtras();
        this.mRunAttemptCount = parameters.getRunAttemptCount();
    }

    public ParcelableWorkerParameters(@NonNull Parcel in) {
        String id = in.readString();
        this.mId = UUID.fromString(id);
        ParcelableData parcelableInputData = new ParcelableData(in);
        this.mData = parcelableInputData.getData();
        this.mTags = new HashSet<String>(in.createStringArrayList());
        ParcelableRuntimeExtras parcelableRuntimeExtras = new ParcelableRuntimeExtras(in);
        this.mRuntimeExtras = parcelableRuntimeExtras.getRuntimeExtras();
        this.mRunAttemptCount = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeString(this.mId.toString());
        ParcelableData parcelableInputData = new ParcelableData(this.mData);
        parcelableInputData.writeToParcel(parcel, flags);
        ArrayList<String> tags = new ArrayList<String>(this.mTags);
        parcel.writeStringList(tags);
        ParcelableRuntimeExtras parcelableRuntimeExtras = new ParcelableRuntimeExtras(this.mRuntimeExtras);
        parcelableRuntimeExtras.writeToParcel(parcel, flags);
        parcel.writeInt(this.mRunAttemptCount);
    }

    @NonNull
    public UUID getId() {
        return this.mId;
    }

    @NonNull
    public Data getData() {
        return this.mData;
    }

    public int getRunAttemptCount() {
        return this.mRunAttemptCount;
    }

    @NonNull
    public Set<String> getTags() {
        return this.mTags;
    }

    @NonNull
    public WorkerParameters toWorkerParameters(@NonNull WorkManagerImpl workManager) {
        Configuration configuration = workManager.getConfiguration();
        WorkDatabase workDatabase = workManager.getWorkDatabase();
        TaskExecutor taskExecutor = workManager.getWorkTaskExecutor();
        Processor foregroundProcessor = workManager.getProcessor();
        return new WorkerParameters(this.mId, this.mData, this.mTags, this.mRuntimeExtras, this.mRunAttemptCount, configuration.getExecutor(), taskExecutor, configuration.getWorkerFactory(), (ProgressUpdater)new WorkProgressUpdater(workDatabase, taskExecutor), (ForegroundUpdater)new WorkForegroundUpdater(workDatabase, (ForegroundProcessor)foregroundProcessor, taskExecutor));
    }
}

