/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.RemoteListenableWorker;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableRemoteWorkRequest;
import androidx.work.multiprocess.parcelable.ParcelableResult;
import androidx.work.multiprocess.parcelable.ParcelableWorkerParameters;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ListenableWorkerImpl
extends IListenableWorkerImpl.Stub {
    static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImpl");
    static byte[] sEMPTY = new byte[0];
    static final Object sLock = new Object();
    final Context mContext;
    final WorkManagerImpl mWorkManager;
    final Configuration mConfiguration;
    final TaskExecutor mTaskExecutor;
    final Map<String, ListenableFuture<ListenableWorker.Result>> mFutureMap;

    ListenableWorkerImpl(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mWorkManager = WorkManagerImpl.getInstance((Context)this.mContext);
        this.mConfiguration = this.mWorkManager.getConfiguration();
        this.mTaskExecutor = this.mWorkManager.getWorkTaskExecutor();
        this.mFutureMap = new HashMap<String, ListenableFuture<ListenableWorker.Result>>();
    }

    public void startWork(@NonNull byte[] request, final @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableRemoteWorkRequest parcelableRemoteWorkRequest = ParcelConverters.unmarshall(request, ParcelableRemoteWorkRequest.CREATOR);
            ParcelableWorkerParameters parcelableWorkerParameters = parcelableRemoteWorkRequest.getParcelableWorkerParameters();
            WorkerParameters workerParameters = parcelableWorkerParameters.toWorkerParameters(this.mWorkManager);
            final String id = workerParameters.getId().toString();
            String workerClassName = parcelableRemoteWorkRequest.getWorkerClassName();
            Logger.get().debug(TAG, String.format("Executing work request (%s, %s)", id, workerClassName), new Throwable[0]);
            final ListenableFuture<ListenableWorker.Result> futureResult = this.executeWorkRequest(id, workerClassName, workerParameters);
            futureResult.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object result = (ListenableWorker.Result)futureResult.get();
                        ParcelableResult parcelableResult = new ParcelableResult((ListenableWorker.Result)result);
                        byte[] response = ParcelConverters.marshall(parcelableResult);
                        ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, response);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, exception);
                    }
                    catch (CancellationException cancellationException) {
                        Logger.get().debug(TAG, String.format("Worker (%s) was cancelled", id), new Throwable[0]);
                        ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, cancellationException);
                    }
                    finally {
                        Object exception = sLock;
                        synchronized (exception) {
                            ListenableWorkerImpl.this.mFutureMap.remove(id);
                        }
                    }
                }
            }, (Executor)this.mTaskExecutor.getBackgroundExecutor());
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(@NonNull byte[] request, final @NonNull IWorkManagerImplCallback callback) {
        try {
            ListenableFuture<ListenableWorker.Result> future;
            ParcelableWorkerParameters parcelableWorkerParameters = ParcelConverters.unmarshall(request, ParcelableWorkerParameters.CREATOR);
            String id = parcelableWorkerParameters.getId().toString();
            Logger.get().debug(TAG, String.format("Interrupting work with id (%s)", id), new Throwable[0]);
            Object object = sLock;
            synchronized (object) {
                future = this.mFutureMap.remove(id);
            }
            if (future != null) {
                this.mWorkManager.getWorkTaskExecutor().getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        future.cancel(true);
                        ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, sEMPTY);
                    }
                });
            } else {
                ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, sEMPTY);
            }
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<ListenableWorker.Result> executeWorkRequest(@NonNull String id, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        SettableFuture future = SettableFuture.create();
        Logger.get().debug(TAG, String.format("Tracking execution of %s (%s)", id, workerClassName), new Throwable[0]);
        Object object = sLock;
        synchronized (object) {
            this.mFutureMap.put(id, (ListenableFuture<ListenableWorker.Result>)future);
        }
        ListenableWorker worker = this.mConfiguration.getWorkerFactory().createWorkerWithDefaultFallback(this.mContext, workerClassName, workerParameters);
        if (worker == null) {
            String message = String.format("Unable to create an instance of %s", workerClassName);
            Logger.get().error(TAG, message, new Throwable[0]);
            future.setException((Throwable)new IllegalStateException(message));
            return future;
        }
        if (!(worker instanceof RemoteListenableWorker)) {
            String message = String.format("%s does not extend %s", workerClassName, RemoteListenableWorker.class.getName());
            Logger.get().error(TAG, message, new Throwable[0]);
            future.setException((Throwable)new IllegalStateException(message));
            return future;
        }
        try {
            RemoteListenableWorker remoteListenableWorker = (RemoteListenableWorker)worker;
            future.setFuture(remoteListenableWorker.startRemoteWork());
        }
        catch (Throwable throwable) {
            future.setException(throwable);
        }
        return future;
    }
}

