/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.RemoteCallback;
import androidx.work.multiprocess.RemoteDispatcher;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ListenableWorkerImplClient {
    static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImplClient");
    final Context mContext;
    final Executor mExecutor;
    private final Object mLock;
    private Connection mConnection;

    public ListenableWorkerImplClient(@NonNull Context context, @NonNull Executor executor) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenableFuture<IListenableWorkerImpl> getListenableWorkerImpl(@NonNull ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection == null) {
                Logger.get().debug(TAG, "Binding to " + component.getPackageName() + ", " + component.getClassName());
                this.mConnection = new Connection();
                try {
                    Intent intent = new Intent();
                    intent.setComponent(component);
                    boolean bound = this.mContext.bindService(intent, (ServiceConnection)this.mConnection, 1);
                    if (!bound) {
                        ListenableWorkerImplClient.unableToBind(this.mConnection, new RuntimeException("Unable to bind to service"));
                    }
                }
                catch (Throwable throwable) {
                    ListenableWorkerImplClient.unableToBind(this.mConnection, throwable);
                }
            }
            return this.mConnection.mFuture;
        }
    }

    @NonNull
    public ListenableFuture<byte[]> execute(@NonNull ComponentName componentName, @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher) {
        ListenableFuture<IListenableWorkerImpl> session = this.getListenableWorkerImpl(componentName);
        return this.execute(session, dispatcher, new RemoteCallback());
    }

    @NonNull
    @SuppressLint(value={"LambdaLast"})
    public ListenableFuture<byte[]> execute(final @NonNull ListenableFuture<IListenableWorkerImpl> session, final @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher, final @NonNull RemoteCallback callback) {
        session.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final IListenableWorkerImpl iListenableWorker = (IListenableWorkerImpl)session.get();
                    callback.setBinder(iListenableWorker.asBinder());
                    ListenableWorkerImplClient.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                dispatcher.execute(iListenableWorker, (IWorkManagerImplCallback)callback);
                            }
                            catch (Throwable innerThrowable) {
                                Logger.get().error(TAG, "Unable to execute", innerThrowable);
                                ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, innerThrowable);
                            }
                        }
                    });
                }
                catch (InterruptedException | ExecutionException exception) {
                    String message = "Unable to bind to service";
                    Logger.get().error(TAG, message, (Throwable)exception);
                    ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, exception);
                }
            }
        }, this.mExecutor);
        return callback.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mConnection);
                this.mConnection = null;
            }
        }
    }

    @Nullable
    @VisibleForTesting
    public Connection getConnection() {
        return this.mConnection;
    }

    private static void unableToBind(@NonNull Connection session, @NonNull Throwable throwable) {
        Logger.get().error(TAG, "Unable to bind to service", throwable);
        session.mFuture.setException(throwable);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Connection
    implements ServiceConnection {
        private static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImplSession");
        final SettableFuture<IListenableWorkerImpl> mFuture = SettableFuture.create();

        public void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
            Logger.get().debug(TAG, "Service connected");
            IListenableWorkerImpl iListenableWorkerImpl = IListenableWorkerImpl.Stub.asInterface((IBinder)iBinder);
            this.mFuture.set((Object)iListenableWorkerImpl);
        }

        public void onServiceDisconnected(@NonNull ComponentName componentName) {
            Logger.get().warning(TAG, "Service disconnected");
            this.mFuture.setException((Throwable)new RuntimeException("Service disconnected"));
        }

        public void onBindingDied(@NonNull ComponentName name) {
            Logger.get().warning(TAG, "Binding died");
            this.mFuture.setException((Throwable)new RuntimeException("Binding died"));
        }

        public void onNullBinding(@NonNull ComponentName name) {
            Logger.get().error(TAG, "Unable to bind to service");
            this.mFuture.setException((Throwable)new RuntimeException("Cannot bind to service " + name));
        }
    }
}

