/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Operation;
import androidx.work.WorkInfo;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.WorkerUpdater;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.utils.WorkForegroundUpdater;
import androidx.work.impl.utils.WorkProgressUpdater;
import androidx.work.impl.utils.taskexecutor.SerialExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.multiprocess.IWorkManagerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableForegroundRequestInfo;
import androidx.work.multiprocess.parcelable.ParcelableUpdateRequest;
import androidx.work.multiprocess.parcelable.ParcelableWorkContinuationImpl;
import androidx.work.multiprocess.parcelable.ParcelableWorkInfos;
import androidx.work.multiprocess.parcelable.ParcelableWorkQuery;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequest;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequests;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteWorkManagerImpl
extends IWorkManagerImpl.Stub {
    static byte[] sEMPTY = new byte[0];
    private final WorkManagerImpl mWorkManager;

    RemoteWorkManagerImpl(@NonNull Context context) {
        this.mWorkManager = WorkManagerImpl.getInstance((Context)context);
    }

    @MainThread
    public void enqueueWorkRequests(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkRequests parcelledRequests = ParcelConverters.unmarshall(request, ParcelableWorkRequests.CREATOR);
            List<WorkRequest> workRequests = parcelledRequests.getRequests();
            Operation operation = this.mWorkManager.enqueue(workRequests);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void enqueueContinuation(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkContinuationImpl parcelledRequest = ParcelConverters.unmarshall(request, ParcelableWorkContinuationImpl.CREATOR);
            WorkContinuationImpl continuation = parcelledRequest.toWorkContinuationImpl(this.mWorkManager);
            Operation operation = continuation.enqueue();
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void cancelWorkById(@NonNull String id, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelWorkById(UUID.fromString(id));
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void cancelAllWorkByTag(@NonNull String tag, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelAllWorkByTag(tag);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void cancelUniqueWork(@NonNull String name, @NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelUniqueWork(name);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void cancelAllWork(@NonNull IWorkManagerImplCallback callback) {
        try {
            Operation operation = this.mWorkManager.cancelAllWork();
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void queryWorkInfo(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkQuery parcelled = ParcelConverters.unmarshall(request, ParcelableWorkQuery.CREATOR);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableFuture future = this.mWorkManager.getWorkInfos(parcelled.getWorkQuery());
            ListenableCallback<List<WorkInfo>> listenableCallback = new ListenableCallback<List<WorkInfo>>((Executor)executor, callback, future){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull List<WorkInfo> result) {
                    ParcelableWorkInfos parcelables = new ParcelableWorkInfos(result);
                    return ParcelConverters.marshall(parcelables);
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void setProgress(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableUpdateRequest parcelled = ParcelConverters.unmarshall(request, ParcelableUpdateRequest.CREATOR);
            Context context = this.mWorkManager.getApplicationContext();
            TaskExecutor taskExecutor = this.mWorkManager.getWorkTaskExecutor();
            SerialExecutor executor = taskExecutor.getSerialTaskExecutor();
            WorkDatabase database = this.mWorkManager.getWorkDatabase();
            WorkProgressUpdater progressUpdater = new WorkProgressUpdater(database, taskExecutor);
            ListenableFuture future = progressUpdater.updateProgress(context, UUID.fromString(parcelled.getId()), parcelled.getData());
            ListenableCallback<Void> listenableCallback = new ListenableCallback<Void>((Executor)executor, callback, future){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Void result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void setForegroundAsync(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableForegroundRequestInfo parcelled = ParcelConverters.unmarshall(request, ParcelableForegroundRequestInfo.CREATOR);
            TaskExecutor taskExecutor = this.mWorkManager.getWorkTaskExecutor();
            SerialExecutor executor = taskExecutor.getSerialTaskExecutor();
            WorkForegroundUpdater foregroundUpdater = new WorkForegroundUpdater(this.mWorkManager.getWorkDatabase(), (ForegroundProcessor)this.mWorkManager.getProcessor(), taskExecutor);
            ListenableFuture future = foregroundUpdater.setForegroundAsync(this.mWorkManager.getApplicationContext(), UUID.fromString(parcelled.getId()), parcelled.getForegroundInfo());
            ListenableCallback<Void> listenableCallback = new ListenableCallback<Void>((Executor)executor, callback, future){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Void result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    public void updateUniquePeriodicWorkRequest(@NonNull String name, @NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableWorkRequest parcelableWorkRequest = ParcelConverters.unmarshall(request, ParcelableWorkRequest.CREATOR);
            WorkRequest workRequest = parcelableWorkRequest.getWorkRequest();
            Operation operation = WorkerUpdater.enqueueUniquelyNamedPeriodic((WorkManagerImpl)this.mWorkManager, (String)name, (WorkRequest)workRequest);
            SerialExecutor executor = this.mWorkManager.getWorkTaskExecutor().getSerialTaskExecutor();
            ListenableCallback<Operation.State.SUCCESS> listenableCallback = new ListenableCallback<Operation.State.SUCCESS>((Executor)executor, callback, operation.getResult()){

                @Override
                @NonNull
                public byte[] toByteArray(@NonNull Operation.State.SUCCESS result) {
                    return sEMPTY;
                }
            };
            listenableCallback.dispatchCallbackSafely();
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }
}

