/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.work.Configuration;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.multiprocess.ListenableWorkerImpl;
import androidx.work.multiprocess.RemoteListenableWorker;
import androidx.work.multiprocess.RemoteWorkerWrapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a5\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"RemoteWorkerWrapper", "Landroidx/work/multiprocess/RemoteWorkerWrapper;", "context", "Landroid/content/Context;", "configuration", "Landroidx/work/Configuration;", "workerClassName", "", "workerParameters", "Landroidx/work/WorkerParameters;", "taskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "create", "work-multiprocess_release"})
public final class RemoteWorkerWrapperKt {
    @JvmName(name="create")
    @NotNull
    public static final RemoteWorkerWrapper create(@NotNull Context context, @NotNull Configuration configuration, @NotNull String workerClassName, @NotNull WorkerParameters workerParameters, @NotNull TaskExecutor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        SettableFuture future = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future");
        RemoteWorkerWrapper wrapper = new RemoteWorkerWrapper((ListenableFuture<ListenableWorker.Result>)((ListenableFuture)future));
        taskExecutor.getMainThreadExecutor().execute(() -> RemoteWorkerWrapperKt.RemoteWorkerWrapper$lambda$1(future, configuration, context, workerClassName, workerParameters, taskExecutor, wrapper));
        return wrapper;
    }

    private static final void RemoteWorkerWrapper$lambda$1$lambda$0(SettableFuture $future, ListenableWorker $worker, RemoteWorkerWrapper $wrapper) {
        Intrinsics.checkNotNullParameter((Object)$wrapper, (String)"$wrapper");
        try {
            $future.get();
        }
        catch (CancellationException e) {
            ((RemoteListenableWorker)$worker).stop($wrapper.getStopReason$work_multiprocess_release().get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final void RemoteWorkerWrapper$lambda$1(SettableFuture $future, Configuration $configuration, Context $context, String $workerClassName, WorkerParameters $workerParameters, TaskExecutor $taskExecutor, RemoteWorkerWrapper $wrapper) {
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$workerClassName, (String)"$workerClassName");
        Intrinsics.checkNotNullParameter((Object)$workerParameters, (String)"$workerParameters");
        Intrinsics.checkNotNullParameter((Object)$taskExecutor, (String)"$taskExecutor");
        Intrinsics.checkNotNullParameter((Object)$wrapper, (String)"$wrapper");
        try {
            if ($future.isCancelled()) {
                return;
            }
            ListenableWorker worker = $configuration.getWorkerFactory().createWorkerWithDefaultFallback($context, $workerClassName, $workerParameters);
            if (worker == null) {
                String message = "Unable to create an instance of " + $workerClassName;
                Logger.get().error(ListenableWorkerImpl.TAG, message);
                $future.setException((Throwable)new IllegalStateException(message));
                return;
            }
            if (!(worker instanceof RemoteListenableWorker)) {
                String message = $workerClassName + " does not extend " + RemoteListenableWorker.class.getName();
                Logger.get().error(ListenableWorkerImpl.TAG, message);
                $future.setException((Throwable)new IllegalStateException(message));
                return;
            }
            $future.addListener(() -> RemoteWorkerWrapperKt.RemoteWorkerWrapper$lambda$1$lambda$0($future, worker, $wrapper), (Executor)$taskExecutor.getSerialTaskExecutor());
            $future.setFuture(((RemoteListenableWorker)worker).startRemoteWork());
        }
        catch (Throwable throwable) {
            $future.setException(throwable);
        }
    }
}

