/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ParcelConverters {
    private ParcelConverters() {
    }

    @NonNull
    public static byte[] marshall(@NonNull Parcelable parcelable) {
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static <T> T unmarshall(@NonNull byte[] array, @NonNull Parcelable.Creator<T> creator) {
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(array, 0, array.length);
            parcel.setDataPosition(0);
            Object object = creator.createFromParcel(parcel);
            return (T)object;
        }
        finally {
            parcel.recycle();
        }
    }
}

