/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.work.WorkerParameters;
import androidx.work.multiprocess.parcelable.ParcelUtils;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableRuntimeExtras
implements Parcelable {
    private WorkerParameters.RuntimeExtras mRuntimeExtras;
    public static final Parcelable.Creator<ParcelableRuntimeExtras> CREATOR = new Parcelable.Creator<ParcelableRuntimeExtras>(){

        @NonNull
        public ParcelableRuntimeExtras createFromParcel(Parcel in) {
            return new ParcelableRuntimeExtras(in);
        }

        public ParcelableRuntimeExtras[] newArray(int size) {
            return new ParcelableRuntimeExtras[size];
        }
    };

    public ParcelableRuntimeExtras(@NonNull WorkerParameters.RuntimeExtras runtimeExtras) {
        this.mRuntimeExtras = runtimeExtras;
    }

    public ParcelableRuntimeExtras(@NonNull Parcel in) {
        ClassLoader loader = this.getClass().getClassLoader();
        Network network = null;
        boolean hasNetwork = ParcelUtils.readBooleanValue(in);
        if (hasNetwork) {
            network = (Network)in.readParcelable(loader);
        }
        ArrayList<Uri> triggeredContentUris = null;
        boolean hasContentUris = ParcelUtils.readBooleanValue(in);
        if (hasContentUris) {
            Parcelable[] parceledUris = in.readParcelableArray(loader);
            triggeredContentUris = new ArrayList<Uri>(parceledUris.length);
            for (Parcelable parcelable : parceledUris) {
                triggeredContentUris.add((Uri)parcelable);
            }
        }
        ArrayList triggeredContentAuthorities = null;
        boolean hasContentAuthorities = ParcelUtils.readBooleanValue(in);
        if (hasContentAuthorities) {
            triggeredContentAuthorities = in.createStringArrayList();
        }
        this.mRuntimeExtras = new WorkerParameters.RuntimeExtras();
        if (Build.VERSION.SDK_INT >= 28) {
            this.mRuntimeExtras.network = network;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            if (triggeredContentUris != null) {
                this.mRuntimeExtras.triggeredContentUris = triggeredContentUris;
            }
            if (triggeredContentAuthorities != null) {
                this.mRuntimeExtras.triggeredContentAuthorities = triggeredContentAuthorities;
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        Network network = null;
        if (Build.VERSION.SDK_INT >= 28) {
            network = this.mRuntimeExtras.network;
        }
        boolean hasNetwork = network != null;
        ParcelUtils.writeBooleanValue(parcel, hasNetwork);
        if (hasNetwork) {
            parcel.writeParcelable(Api21Impl.castToParcelable(network), flags);
        }
        List triggeredContentUris = null;
        List triggeredAuthorities = null;
        if (Build.VERSION.SDK_INT >= 24) {
            triggeredContentUris = this.mRuntimeExtras.triggeredContentUris;
            triggeredAuthorities = this.mRuntimeExtras.triggeredContentAuthorities;
        }
        boolean hasContentUris = triggeredContentUris != null && !triggeredContentUris.isEmpty();
        ParcelUtils.writeBooleanValue(parcel, hasContentUris);
        if (hasContentUris) {
            Uri[] contentUriArray = new Uri[triggeredContentUris.size()];
            for (int i = 0; i < contentUriArray.length; ++i) {
                contentUriArray[i] = (Uri)triggeredContentUris.get(i);
            }
            parcel.writeParcelableArray((Parcelable[])contentUriArray, flags);
        }
        boolean hasContentAuthorities = triggeredAuthorities != null && !triggeredAuthorities.isEmpty();
        ParcelUtils.writeBooleanValue(parcel, hasContentAuthorities);
        if (hasContentAuthorities) {
            parcel.writeStringList(triggeredAuthorities);
        }
    }

    @NonNull
    public WorkerParameters.RuntimeExtras getRuntimeExtras() {
        return this.mRuntimeExtras;
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static Parcelable castToParcelable(Network network) {
            return network;
        }
    }
}

