/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemjob.SystemJobInfoConverter;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.IdGenerator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
public class SystemJobScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix("SystemJobScheduler");
    private final JobScheduler mJobScheduler;
    private final WorkManagerImpl mWorkManager;
    private final IdGenerator mIdGenerator;
    private final SystemJobInfoConverter mSystemJobInfoConverter;

    public SystemJobScheduler(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this(context, workManager, (JobScheduler)context.getSystemService("jobscheduler"), new SystemJobInfoConverter(context));
    }

    @VisibleForTesting
    public SystemJobScheduler(Context context, WorkManagerImpl workManager, JobScheduler jobScheduler, SystemJobInfoConverter systemJobInfoConverter) {
        this.mWorkManager = workManager;
        this.mJobScheduler = jobScheduler;
        this.mIdGenerator = new IdGenerator(context);
        this.mSystemJobInfoConverter = systemJobInfoConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        WorkDatabase workDatabase = this.mWorkManager.getWorkDatabase();
        for (WorkSpec workSpec : workSpecs) {
            workDatabase.beginTransaction();
            try {
                int jobId;
                JobInfo jobInfo;
                WorkSpec currentDbWorkSpec = workDatabase.workSpecDao().getWorkSpec(workSpec.id);
                if (currentDbWorkSpec == null) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it's no longer in the DB", new Throwable[0]);
                    continue;
                }
                if (currentDbWorkSpec.state != WorkInfo.State.ENQUEUED) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it is no longer enqueued", new Throwable[0]);
                    continue;
                }
                SystemIdInfo info = workDatabase.systemIdInfoDao().getSystemIdInfo(workSpec.id);
                if (info != null && (jobInfo = SystemJobScheduler.getPendingJobInfo(this.mJobScheduler, workSpec.id)) != null) {
                    Logger.get().debug(TAG, String.format("Skipping scheduling %s because JobScheduler is aware of it already.", workSpec.id), new Throwable[0]);
                    continue;
                }
                int n = jobId = info != null ? info.systemId : this.mIdGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                if (info == null) {
                    SystemIdInfo newSystemIdInfo = new SystemIdInfo(workSpec.id, jobId);
                    this.mWorkManager.getWorkDatabase().systemIdInfoDao().insertSystemIdInfo(newSystemIdInfo);
                }
                this.scheduleInternal(workSpec, jobId);
                if (Build.VERSION.SDK_INT == 23) {
                    int nextJobId = this.mIdGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                    this.scheduleInternal(workSpec, nextJobId);
                }
                workDatabase.setTransactionSuccessful();
            }
            finally {
                workDatabase.endTransaction();
            }
        }
    }

    @VisibleForTesting
    public void scheduleInternal(WorkSpec workSpec, int jobId) {
        JobInfo jobInfo = this.mSystemJobInfoConverter.convert(workSpec, jobId);
        Logger.get().debug(TAG, String.format("Scheduling work ID %s Job ID %s", workSpec.id, jobId), new Throwable[0]);
        this.mJobScheduler.schedule(jobInfo);
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        List allJobInfos = this.mJobScheduler.getAllPendingJobs();
        if (allJobInfos != null) {
            for (JobInfo jobInfo : allJobInfos) {
                if (!workSpecId.equals(jobInfo.getExtras().getString("EXTRA_WORK_SPEC_ID"))) continue;
                this.mWorkManager.getWorkDatabase().systemIdInfoDao().removeSystemIdInfo(workSpecId);
                this.mJobScheduler.cancel(jobInfo.getId());
                if (Build.VERSION.SDK_INT == 23) continue;
                return;
            }
        }
    }

    public static void jobSchedulerCancelAll(@NonNull Context context) {
        List jobInfos;
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null && (jobInfos = jobScheduler.getAllPendingJobs()) != null) {
            for (JobInfo jobInfo : jobInfos) {
                PersistableBundle extras = jobInfo.getExtras();
                if (!extras.containsKey("EXTRA_WORK_SPEC_ID")) continue;
                jobScheduler.cancel(jobInfo.getId());
            }
        }
    }

    private static JobInfo getPendingJobInfo(@NonNull JobScheduler jobScheduler, @NonNull String workSpecId) {
        List jobInfos = jobScheduler.getAllPendingJobs();
        if (jobInfos != null) {
            for (JobInfo jobInfo : jobInfos) {
                PersistableBundle extras = jobInfo.getExtras();
                if (extras == null || !extras.containsKey("EXTRA_WORK_SPEC_ID") || !workSpecId.equals(extras.getString("EXTRA_WORK_SPEC_ID"))) continue;
                return jobInfo;
            }
        }
        return null;
    }
}

