/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ContentUriTriggers {
    private final Set<Trigger> mTriggers = new HashSet<Trigger>();

    public void add(@NonNull Uri uri, boolean triggerForDescendants) {
        Trigger trigger = new Trigger(uri, triggerForDescendants);
        this.mTriggers.add(trigger);
    }

    @NonNull
    public Set<Trigger> getTriggers() {
        return this.mTriggers;
    }

    public int size() {
        return this.mTriggers.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentUriTriggers that = (ContentUriTriggers)o;
        return this.mTriggers.equals(that.mTriggers);
    }

    public int hashCode() {
        return this.mTriggers.hashCode();
    }

    public static final class Trigger {
        @NonNull
        private final Uri mUri;
        private final boolean mTriggerForDescendants;

        Trigger(@NonNull Uri uri, boolean triggerForDescendants) {
            this.mUri = uri;
            this.mTriggerForDescendants = triggerForDescendants;
        }

        @NonNull
        public Uri getUri() {
            return this.mUri;
        }

        public boolean shouldTriggerForDescendants() {
            return this.mTriggerForDescendants;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trigger trigger = (Trigger)o;
            return this.mTriggerForDescendants == trigger.mTriggerForDescendants && this.mUri.equals((Object)trigger.mUri);
        }

        public int hashCode() {
            int result = this.mUri.hashCode();
            result = 31 * result + (this.mTriggerForDescendants ? 1 : 0);
            return result;
        }
    }
}

