/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.greedy;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GreedyScheduler
implements Scheduler,
WorkConstraintsCallback,
ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("GreedyScheduler");
    private WorkManagerImpl mWorkManagerImpl;
    private WorkConstraintsTracker mWorkConstraintsTracker;
    private List<WorkSpec> mConstrainedWorkSpecs = new ArrayList<WorkSpec>();
    private boolean mRegisteredExecutionListener;
    private final Object mLock;

    public GreedyScheduler(Context context, WorkManagerImpl workManagerImpl) {
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = new WorkConstraintsTracker(context, this);
        this.mLock = new Object();
    }

    @VisibleForTesting
    public GreedyScheduler(WorkManagerImpl workManagerImpl, WorkConstraintsTracker workConstraintsTracker) {
        this.mWorkManagerImpl = workManagerImpl;
        this.mWorkConstraintsTracker = workConstraintsTracker;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        this.registerExecutionListenerIfNeeded();
        ArrayList<WorkSpec> constrainedWorkSpecs = new ArrayList<WorkSpec>();
        ArrayList<String> constrainedWorkSpecIds = new ArrayList<String>();
        for (WorkSpec workSpec : workSpecs) {
            if (workSpec.state != WorkInfo.State.ENQUEUED || workSpec.isPeriodic() || workSpec.initialDelay != 0L || workSpec.isBackedOff()) continue;
            if (workSpec.hasConstraints()) {
                if (Build.VERSION.SDK_INT >= 24 && workSpec.constraints.hasContentUriTriggers()) continue;
                constrainedWorkSpecs.add(workSpec);
                constrainedWorkSpecIds.add(workSpec.id);
                continue;
            }
            Logger.get().debug(TAG, String.format("Starting work for %s", workSpec.id), new Throwable[0]);
            this.mWorkManagerImpl.startWork(workSpec.id);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!constrainedWorkSpecs.isEmpty()) {
                Logger.get().debug(TAG, String.format("Starting tracking for [%s]", TextUtils.join((CharSequence)",", constrainedWorkSpecIds)), new Throwable[0]);
                this.mConstrainedWorkSpecs.addAll(constrainedWorkSpecs);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
            }
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        this.registerExecutionListenerIfNeeded();
        Logger.get().debug(TAG, String.format("Cancelling work ID %s", workSpecId), new Throwable[0]);
        this.mWorkManagerImpl.stopWork(workSpecId);
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<String> workSpecIds) {
        for (String workSpecId : workSpecIds) {
            Logger.get().debug(TAG, String.format("Constraints met: Scheduling work ID %s", workSpecId), new Throwable[0]);
            this.mWorkManagerImpl.startWork(workSpecId);
        }
    }

    @Override
    public void onAllConstraintsNotMet(@NonNull List<String> workSpecIds) {
        for (String workSpecId : workSpecIds) {
            Logger.get().debug(TAG, String.format("Constraints not met: Cancelling work ID %s", workSpecId), new Throwable[0]);
            this.mWorkManagerImpl.stopWork(workSpecId);
        }
    }

    @Override
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        this.removeConstraintTrackingFor(workSpecId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstraintTrackingFor(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mConstrainedWorkSpecs.size();
            for (int i = 0; i < size; ++i) {
                if (!this.mConstrainedWorkSpecs.get((int)i).id.equals(workSpecId)) continue;
                Logger.get().debug(TAG, String.format("Stopping tracking for %s", workSpecId), new Throwable[0]);
                this.mConstrainedWorkSpecs.remove(i);
                this.mWorkConstraintsTracker.replace(this.mConstrainedWorkSpecs);
                break;
            }
        }
    }

    private void registerExecutionListenerIfNeeded() {
        if (!this.mRegisteredExecutionListener) {
            this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
            this.mRegisteredExecutionListener = true;
        }
    }
}

