/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

class WorkManagerLiveDataTracker {
    @VisibleForTesting
    final Set<LiveData> mLiveDataSet = Collections.newSetFromMap(new IdentityHashMap());

    WorkManagerLiveDataTracker() {
    }

    public <T> LiveData<T> track(LiveData<T> other) {
        return new TrackedLiveData<T>(this, other);
    }

    void onActive(LiveData liveData) {
        this.mLiveDataSet.add(liveData);
    }

    void onInactive(LiveData liveData) {
        this.mLiveDataSet.remove(liveData);
    }

    static class TrackedLiveData<T>
    extends MediatorLiveData<T> {
        private final WorkManagerLiveDataTracker mContainer;

        TrackedLiveData(WorkManagerLiveDataTracker container, LiveData<T> wrapped) {
            this.mContainer = container;
            this.addSource(wrapped, new Observer<T>(){

                public void onChanged(@Nullable T t) {
                    this.setValue(t);
                }
            });
        }

        protected void onActive() {
            super.onActive();
            this.mContainer.onActive((LiveData)this);
        }

        protected void onInactive() {
            super.onInactive();
            this.mContainer.onInactive((LiveData)this);
        }
    }
}

