/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.work.Data;
import androidx.work.impl.WorkDatabaseMigrations;
import androidx.work.impl.model.Dependency;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.WorkName;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTag;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Database(entities={Dependency.class, WorkSpec.class, WorkTag.class, SystemIdInfo.class, WorkName.class}, version=6)
@TypeConverters(value={Data.class, WorkTypeConverters.class})
public abstract class WorkDatabase
extends RoomDatabase {
    private static final String DB_NAME = "androidx.work.workdb";
    private static final String PRUNE_SQL_FORMAT_PREFIX = "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (period_start_time + minimum_retention_duration) < ";
    private static final String PRUNE_SQL_FORMAT_SUFFIX = " AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
    private static final long PRUNE_THRESHOLD_MILLIS = TimeUnit.DAYS.toMillis(7L);

    public static WorkDatabase create(@NonNull Context context, @NonNull Executor queryExecutor, boolean useTestDatabase) {
        RoomDatabase.Builder builder = useTestDatabase ? Room.inMemoryDatabaseBuilder((Context)context, WorkDatabase.class).allowMainThreadQueries() : Room.databaseBuilder((Context)context, WorkDatabase.class, (String)DB_NAME).setQueryExecutor(queryExecutor);
        return (WorkDatabase)builder.addCallback(WorkDatabase.generateCleanupCallback()).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_1_2}).addMigrations(new Migration[]{new WorkDatabaseMigrations.WorkMigration(context, 2, 3)}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_3_4}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_4_5}).addMigrations(new Migration[]{new WorkDatabaseMigrations.WorkMigration(context, 5, 6)}).fallbackToDestructiveMigration().build();
    }

    static RoomDatabase.Callback generateCleanupCallback() {
        return new RoomDatabase.Callback(){

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                super.onOpen(db);
                db.beginTransaction();
                try {
                    db.execSQL(WorkDatabase.getPruneSQL());
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
        };
    }

    static String getPruneSQL() {
        return PRUNE_SQL_FORMAT_PREFIX + WorkDatabase.getPruneDate() + PRUNE_SQL_FORMAT_SUFFIX;
    }

    static long getPruneDate() {
        return System.currentTimeMillis() - PRUNE_THRESHOLD_MILLIS;
    }

    public abstract WorkSpecDao workSpecDao();

    public abstract DependencyDao dependencyDao();

    public abstract WorkTagDao workTagDao();

    public abstract SystemIdInfoDao systemIdInfoDao();

    public abstract WorkNameDao workNameDao();
}

