/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.net.ConnectivityManagerCompat;
import androidx.work.Logger;
import androidx.work.impl.constraints.NetworkState;
import androidx.work.impl.constraints.trackers.ConstraintTracker;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NetworkStateTracker
extends ConstraintTracker<NetworkState> {
    static final String TAG = Logger.tagWithPrefix("NetworkStateTracker");
    private final ConnectivityManager mConnectivityManager;
    @RequiresApi(value=24)
    private NetworkStateCallback mNetworkCallback;
    private NetworkStateBroadcastReceiver mBroadcastReceiver;

    public NetworkStateTracker(@NonNull Context context, @NonNull TaskExecutor taskExecutor) {
        super(context, taskExecutor);
        this.mConnectivityManager = (ConnectivityManager)this.mAppContext.getSystemService("connectivity");
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            this.mNetworkCallback = new NetworkStateCallback();
        } else {
            this.mBroadcastReceiver = new NetworkStateBroadcastReceiver();
        }
    }

    @Override
    public NetworkState getInitialState() {
        return this.getActiveNetworkState();
    }

    @Override
    public void startTracking() {
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            try {
                Logger.get().debug(TAG, "Registering network callback", new Throwable[0]);
                this.mConnectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
            }
            catch (IllegalArgumentException | SecurityException e) {
                Logger.get().error(TAG, "Received exception while registering network callback", e);
            }
        } else {
            Logger.get().debug(TAG, "Registering broadcast receiver", new Throwable[0]);
            this.mAppContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    @Override
    public void stopTracking() {
        if (NetworkStateTracker.isNetworkCallbackSupported()) {
            try {
                Logger.get().debug(TAG, "Unregistering network callback", new Throwable[0]);
                this.mConnectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
            }
            catch (IllegalArgumentException | SecurityException e) {
                Logger.get().error(TAG, "Received exception while unregistering network callback", e);
            }
        } else {
            Logger.get().debug(TAG, "Unregistering broadcast receiver", new Throwable[0]);
            this.mAppContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        }
    }

    private static boolean isNetworkCallbackSupported() {
        return Build.VERSION.SDK_INT >= 24;
    }

    NetworkState getActiveNetworkState() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        boolean isConnected = info != null && info.isConnected();
        boolean isValidated = this.isActiveNetworkValidated();
        boolean isMetered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
        boolean isNotRoaming = info != null && !info.isRoaming();
        return new NetworkState(isConnected, isValidated, isMetered, isNotRoaming);
    }

    @VisibleForTesting
    boolean isActiveNetworkValidated() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        try {
            Network network = this.mConnectivityManager.getActiveNetwork();
            NetworkCapabilities capabilities = this.mConnectivityManager.getNetworkCapabilities(network);
            return capabilities != null && capabilities.hasCapability(16);
        }
        catch (SecurityException exception) {
            Logger.get().error(TAG, "Unable to validate active network", exception);
            return false;
        }
    }

    private class NetworkStateBroadcastReceiver
    extends BroadcastReceiver {
        NetworkStateBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return;
            }
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                Logger.get().debug(TAG, "Network broadcast received", new Throwable[0]);
                NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
            }
        }
    }

    @RequiresApi(value=24)
    private class NetworkStateCallback
    extends ConnectivityManager.NetworkCallback {
        NetworkStateCallback() {
        }

        public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities capabilities) {
            Logger.get().debug(TAG, String.format("Network capabilities changed: %s", capabilities), new Throwable[0]);
            NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
        }

        public void onLost(@NonNull Network network) {
            Logger.get().debug(TAG, "Network connection lost", new Throwable[0]);
            NetworkStateTracker.this.setState(NetworkStateTracker.this.getActiveNetworkState());
        }
    }
}

