/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.os.BuildCompat;
import androidx.work.ForegroundInfo;
import androidx.work.ForegroundUpdater;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkForegroundRunnable
implements Runnable {
    static final String TAG = Logger.tagWithPrefix("WorkForegroundRunnable");
    final SettableFuture<Void> mFuture = SettableFuture.create();
    final Context mContext;
    final WorkSpec mWorkSpec;
    final ListenableWorker mWorker;
    final ForegroundUpdater mForegroundUpdater;
    final TaskExecutor mTaskExecutor;

    @SuppressLint(value={"LambdaLast"})
    public WorkForegroundRunnable(@NonNull Context context, @NonNull WorkSpec workSpec, @NonNull ListenableWorker worker, @NonNull ForegroundUpdater foregroundUpdater, @NonNull TaskExecutor taskExecutor) {
        this.mContext = context;
        this.mWorkSpec = workSpec;
        this.mWorker = worker;
        this.mForegroundUpdater = foregroundUpdater;
        this.mTaskExecutor = taskExecutor;
    }

    @NonNull
    public ListenableFuture<Void> getFuture() {
        return this.mFuture;
    }

    @Override
    @SuppressLint(value={"UnsafeExperimentalUsageError"})
    public void run() {
        if (!this.mWorkSpec.expedited || BuildCompat.isAtLeastS()) {
            this.mFuture.set(null);
            return;
        }
        final SettableFuture foregroundFuture = SettableFuture.create();
        this.mTaskExecutor.getMainThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                foregroundFuture.setFuture(WorkForegroundRunnable.this.mWorker.getForegroundInfoAsync());
            }
        });
        foregroundFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    ForegroundInfo foregroundInfo = (ForegroundInfo)foregroundFuture.get();
                    if (foregroundInfo == null) {
                        String message = String.format("Worker was marked important (%s) but did not provide ForegroundInfo", WorkForegroundRunnable.this.mWorkSpec.workerClassName);
                        throw new IllegalStateException(message);
                    }
                    Logger.get().debug(TAG, String.format("Updating notification for %s", WorkForegroundRunnable.this.mWorkSpec.workerClassName), new Throwable[0]);
                    WorkForegroundRunnable.this.mWorker.setRunInForeground(true);
                    WorkForegroundRunnable.this.mFuture.setFuture(WorkForegroundRunnable.this.mForegroundUpdater.setForegroundAsync(WorkForegroundRunnable.this.mContext, WorkForegroundRunnable.this.mWorker.getId(), foregroundInfo));
                }
                catch (Throwable throwable) {
                    WorkForegroundRunnable.this.mFuture.setException(throwable);
                }
            }
        }, this.mTaskExecutor.getMainThreadExecutor());
    }
}

