/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\fJ\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Landroidx/work/lint/IdleBatteryChargingConstraintsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "identifierName", "isArgumentTrue", "", "Companion", "work-runtime-lint"})
public final class IdleBatteryChargingConstraintsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DESCRIPTION = "Constraints may not be met for some devices";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setRequiresDeviceIdle");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Ref.BooleanRef reported = new Ref.BooleanRef();
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "androidx.work.Constraints.Builder") && this.isArgumentTrue(node, context)) {
            PsiElement sourcePsi;
            String name = this.identifierName(node);
            UExpression uExpression = node.getReceiver();
            PsiElement psiElement = sourcePsi = uExpression == null ? null : uExpression.getSourcePsi();
            if (sourcePsi != null) {
                UElement uElement;
                PsiElement psiElement2;
                UBlockExpression uBlockExpression;
                UElement uElement2 = UastContextKt.toUElement((PsiElement)sourcePsi);
                if (uElement2 == null) {
                    uBlockExpression = null;
                } else {
                    UElement $this$getParentOfType$iv = uElement2;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    uBlockExpression = (UBlockExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UBlockExpression.class, (boolean)strict$iv);
                }
                UBlockExpression blockExpression = uBlockExpression;
                AbstractUastVisitor visitor2 = new AbstractUastVisitor(this, context, name, reported){
                    final /* synthetic */ IdleBatteryChargingConstraintsDetector this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ String $name;
                    final /* synthetic */ Ref.BooleanRef $reported;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$name = $name;
                        this.$reported = $reported;
                    }

                    public boolean visitCallExpression(@NotNull UCallExpression node) {
                        PsiType psiType;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        String variableName = this.this$0.identifierName(node);
                        if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"setRequiresCharging") && this.this$0.isArgumentTrue(node, this.$context) && Intrinsics.areEqual((Object)this.$name, (Object)variableName) && Intrinsics.areEqual((Object)((psiType = node.getReceiverType()) == null ? null : psiType.getCanonicalText()), (Object)"androidx.work.Constraints.Builder") && !this.$reported.element) {
                            this.$reported.element = true;
                            Context.report$default((Context)((Context)this.$context), (Issue)IdleBatteryChargingConstraintsDetector.Companion.getISSUE(), (Location)this.$context.getLocation((UElement)node), (String)"Constraints may not be met for some devices", null, (int)8, null);
                        }
                        return true;
                    }
                };
                UBlockExpression uBlockExpression2 = blockExpression;
                if (uBlockExpression2 != null && (psiElement2 = uBlockExpression2.getSourcePsi()) != null && (uElement = UastContextKt.toUElement((PsiElement)psiElement2)) != null) {
                    uElement.accept((UastVisitor)visitor2);
                }
            }
        }
    }

    public final boolean isArgumentTrue(@NotNull UCallExpression $this$isArgumentTrue, @NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isArgumentTrue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$isArgumentTrue.getValueArgumentCount() > 0) {
            Object value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)CollectionsKt.first((List)$this$isArgumentTrue.getValueArguments())));
            return Intrinsics.areEqual((Object)value, (Object)true);
        }
        return false;
    }

    @Nullable
    public final String identifierName(@NotNull UCallExpression $this$identifierName) {
        Intrinsics.checkNotNullParameter((Object)$this$identifierName, (String)"<this>");
        UExpression current = $this$identifierName.getReceiver();
        while (current != null && !(current instanceof USimpleNameReferenceExpression)) {
            UExpression uExpression = current;
            UQualifiedReferenceExpression uQualifiedReferenceExpression = uExpression instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uExpression : null;
            current = uQualifiedReferenceExpression == null ? null : uQualifiedReferenceExpression.getReceiver();
        }
        if (current != null && current instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)current).getIdentifier();
        }
        return null;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(IdleBatteryChargingConstraintsDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"IdleBatteryChargingConstraints", (String)DESCRIPTION, (String)"\n                Some devices are never considered charging and idle at the same time.\n                Consider removing one of these constraints.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/work/lint/IdleBatteryChargingConstraintsDetector$Companion;", "", "()V", "DESCRIPTION", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

